/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_6328;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.advancement.CNAdvancement;
import net.nuclearteam.createnuclear.compact.archEx.CNArchExCompat;
import net.nuclearteam.createnuclear.datagen.CNGeneratedEntriesProvider;
import net.nuclearteam.createnuclear.datagen.CNProcessingRecipeGen;
import net.nuclearteam.createnuclear.datagen.CNRegistrateTags;
import net.nuclearteam.createnuclear.datagen.recipe.cooking.CNCookingRecipeGen;
import net.nuclearteam.createnuclear.datagen.recipe.crafting.CNStandardRecipeGen;
import net.nuclearteam.createnuclear.datagen.recipe.mechanical_crafter.CNMechanicalCraftingRecipeGen;
import net.nuclearteam.createnuclear.datagen.recipe.shapeless.CNShapelessRecipeGen;
import net.nuclearteam.createnuclear.ponder.CNPonderIndex;

@class_6328
@ParametersAreNonnullByDefault
public class CreateNuclearDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        ExistingFileHelper helper = ExistingFileHelper.withResourcesFromArg();
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        CreateNuclear.REGISTRATE.setupDatagen(pack, helper);
        CreateNuclearDataGenerator.gatherData(pack, helper);
        CNArchExCompat.init(pack);
    }

    public static void gatherData(FabricDataGenerator.Pack pack, ExistingFileHelper existingFileHelper) {
        CreateNuclearDataGenerator.addExtraRegistrateData();
        pack.addProvider(CNAdvancement::new);
        pack.addProvider(CNGeneratedEntriesProvider::new);
        pack.addProvider(CNProcessingRecipeGen::registerAll);
        pack.addProvider(CNStandardRecipeGen::new);
        pack.addProvider(CNCookingRecipeGen::new);
        pack.addProvider(CNMechanicalCraftingRecipeGen::new);
        pack.addProvider(CNShapelessRecipeGen::new);
    }

    private static void addExtraRegistrateData() {
        CNRegistrateTags.addGenerators();
        CreateNuclear.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            CreateNuclearDataGenerator.provideDefaultLang("interface", langConsumer);
            CreateNuclearDataGenerator.provideDefaultLang("potion", langConsumer);
            CreateNuclearDataGenerator.provideDefaultLang("entity", langConsumer);
            CreateNuclearDataGenerator.provideDefaultLang("tooltips", langConsumer);
            CreateNuclearDataGenerator.provideDefaultLang("reactor", langConsumer);
            CNAdvancement.provideLang(langConsumer);
            CreateNuclearDataGenerator.providePonderLang(langConsumer);
        });
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/createnuclear/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    private static void providePonderLang(BiConsumer<String, String> consumer) {
        CNPonderIndex.register();
        PonderLocalization.generateSceneLang();
        PonderLocalization.provideLang((String)"createnuclear", consumer);
    }
}

