/*
 * Decompiled with CFR 0.152.
 */
package lib.multiblock.test;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lib.multiblock.test.impl.IMultiBlockPattern;
import lib.multiblock.test.impl.IMultiBlockPatternBuilder;
import lib.multiblock.test.impl.IPatternBuilder;
import lib.multiblock.test.misc.MultiBlockOffsetPos;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2694;

public final class SimpleMultiBlockPatternBuilder
implements IMultiBlockPatternBuilder {
    private static final Joiner COMA_SEPARATOR = Joiner.on((char)',');
    private final Map<Character, List<MultiBlockOffsetPos>> multiBlockOffsetPosList = Maps.newHashMap();
    private final Map<Character, Predicate<class_2694>> predicateHashMap = Maps.newHashMap();
    private final Map<Character, Supplier<class_2680>> blockProvider = Maps.newHashMap();

    public static SimpleMultiBlockPatternBuilder start() {
        return new SimpleMultiBlockPatternBuilder();
    }

    private SimpleMultiBlockPatternBuilder() {
    }

    private void ensureProperlyBuilt(List<MultiBlockOffsetPos> list) {
        HashSet characters = new HashSet();
        list.forEach(multiBlockOffsetPos -> {
            if (!this.predicateHashMap.containsKey(Character.valueOf(multiBlockOffsetPos.caracter()))) {
                characters.add(Character.valueOf(multiBlockOffsetPos.caracter()));
            }
        });
        if (!characters.isEmpty()) {
            throw new IllegalStateException("Missing the following: \"%s\" for MultiBlock Pattern as they have not been defined".formatted(COMA_SEPARATOR.join(characters)));
        }
    }

    public SimpleMultiBlockPatternBuilder add(char character, class_2338 relativePos) {
        this.multiBlockOffsetPosList.computeIfAbsent(Character.valueOf(character), ArrayList::new).add(new MultiBlockOffsetPos(character, relativePos));
        return this;
    }

    public SimpleMultiBlockPatternBuilder where(char character, Predicate<class_2694> worldPredicate) {
        if (!this.predicateHashMap.containsKey(Character.valueOf(character))) {
            this.predicateHashMap.put(Character.valueOf(character), worldPredicate);
        }
        return this;
    }

    public SimpleMultiBlockPatternBuilder block(char pSymbol, Supplier<class_2680> blockStateSupplier) {
        this.blockProvider.put(Character.valueOf(pSymbol), blockStateSupplier);
        return this;
    }

    @Override
    public <T extends IMultiBlockPattern> T build(IPatternBuilder<T> builder) {
        List<MultiBlockOffsetPos> coreList = this.multiBlockOffsetPosList.get(Character.valueOf('*'));
        if (coreList == null || coreList.size() != 1) {
            throw new IllegalArgumentException("Failed to build pattern due to having more or less than one \"*\" defined! Have: %s Expected: 1".formatted(coreList != null ? coreList.size() : 0));
        }
        ArrayList list = Lists.newArrayList();
        this.multiBlockOffsetPosList.forEach((k, v) -> list.addAll(v));
        return builder.make(list, this.predicateHashMap, this.blockProvider);
    }
}

