/*
 * Decompiled with CFR 0.152.
 */
package lib.multiblock.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import lib.multiblock.test.impl.IMultiBlockPattern;
import lib.multiblock.test.misc.MultiBlockOffsetPos;
import lib.multiblock.test.misc.MultiblockMatchResult;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_3738;
import net.minecraft.class_4538;

public final class SimpleMultiBlockPattern
implements IMultiBlockPattern {
    private final List<MultiBlockOffsetPos> multiBlockOffsetPosList;
    private final Map<Character, Predicate<class_2694>> predicateHashMap;
    private final Map<Character, Supplier<class_2680>> blockProvider;

    public SimpleMultiBlockPattern(List<MultiBlockOffsetPos> multiBlockOffsetPosList, Map<Character, Predicate<class_2694>> predicateMap, Map<Character, Supplier<class_2680>> blockSuppliers) {
        this.multiBlockOffsetPosList = List.copyOf(multiBlockOffsetPosList);
        this.predicateHashMap = Map.copyOf(predicateMap);
        this.blockProvider = Map.copyOf(blockSuppliers);
    }

    @Override
    public boolean matches(class_1937 level, class_2338 blockPos, class_2470 rotation) {
        for (MultiBlockOffsetPos multiBlockOffsetPos : this.multiBlockOffsetPosList) {
            char character = multiBlockOffsetPos.caracter();
            Predicate<class_2694> predicate = this.predicateHashMap.get(Character.valueOf(character));
            class_2694 block = new class_2694((class_4538)level, blockPos.method_10081((class_2382)multiBlockOffsetPos.pos().method_10070(rotation)), false);
            if (predicate != null && predicate.test(block)) continue;
            return false;
        }
        return true;
    }

    @Override
    public MultiblockMatchResult matchesWithResult(class_1937 level, class_2338 blockPos, class_2470 rotation) {
        ArrayList<class_2694> result = new ArrayList<class_2694>();
        for (MultiBlockOffsetPos multiBlockOffsetPos : this.multiBlockOffsetPosList) {
            char character = multiBlockOffsetPos.caracter();
            Predicate<class_2694> predicate = this.predicateHashMap.get(Character.valueOf(character));
            class_2694 block = new class_2694((class_4538)level, blockPos.method_10081((class_2382)multiBlockOffsetPos.pos().method_10070(rotation)), false);
            if (predicate == null || !predicate.test(block)) {
                return null;
            }
            result.add(block);
        }
        return new MultiblockMatchResult(List.copyOf(result));
    }

    @Override
    public void construct(class_1937 level, class_2338 blockPos, BiPredicate<Character, class_2680> stateBiPredicate) {
        if (level.field_9236) {
            return;
        }
        if (level.method_8503() == null) {
            return;
        }
        for (MultiBlockOffsetPos multiBlockOffsetPos : this.multiBlockOffsetPosList) {
            char character = multiBlockOffsetPos.caracter();
            Supplier<class_2680> stateSupplier = this.blockProvider.get(Character.valueOf(character));
            if (stateSupplier == null) continue;
            class_2338 pos = blockPos.method_10081((class_2382)multiBlockOffsetPos.pos().method_10070(class_2470.field_11467));
            class_2680 state = stateSupplier.get();
            if (!stateBiPredicate.test(Character.valueOf(character), state)) continue;
            level.method_8503().method_18858((Runnable)new class_3738(3, () -> level.method_8652(pos, state, 3)));
        }
    }

    @Override
    public boolean matches(Level level, class_2338 pos, class_2470 rotation) {
        return false;
    }

    public List<MultiBlockOffsetPos> test() {
        return this.multiBlockOffsetPosList;
    }
}

