/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import com.simibubi.create.foundation.gui.widget.ElementWidget;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.class_1799;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class PonderButton
extends BoxWidget {
    protected class_1799 item;
    protected PonderTag tag;
    protected class_304 shortcut;
    protected LerpedFloat flash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);

    public PonderButton(int x, int y) {
        this(x, y, 20, 20);
    }

    public PonderButton(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.z = 420.0f;
        this.paddingX = 2.0f;
        this.paddingY = 2.0f;
    }

    public <T extends PonderButton> T withShortcut(class_304 key) {
        this.shortcut = key;
        return (T)this;
    }

    public <T extends PonderButton> T showingTag(PonderTag tag) {
        this.tag = tag;
        return (T)((PonderButton)this.showing(this.tag));
    }

    public <T extends PonderButton> T showing(class_1799 item) {
        this.item = item;
        return (T)((PonderButton)super.showingElement((RenderElement)GuiGameElement.of(item).scale(1.5).at(-4.0f, -4.0f)));
    }

    @Override
    public <T extends ElementWidget> T showingElement(RenderElement element) {
        return super.showingElement(element);
    }

    public void flash() {
        this.flash.updateChaseTarget(1.0f);
    }

    public void dim() {
        this.flash.updateChaseTarget(0.0f);
    }

    @Override
    public void tick() {
        super.tick();
        this.flash.tickChaser();
    }

    @Override
    protected void beforeRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(graphics, mouseX, mouseY, partialTicks);
        float flashValue = this.flash.getValue(partialTicks);
        if (flashValue > 0.1f) {
            float sin = 0.5f + 0.5f * class_3532.method_15374((float)(((float)AnimationTickHolder.getTicks(true) + partialTicks) / 5.0f));
            Color nc1 = new Color(255, 255, 255, class_3532.method_15340((int)(this.gradientColor1.getAlpha() + 150), (int)0, (int)255));
            Color nc2 = new Color(155, 155, 155, class_3532.method_15340((int)(this.gradientColor2.getAlpha() + 150), (int)0, (int)255));
            this.gradientColor1 = this.gradientColor1.mixWith(nc1, sin *= flashValue);
            this.gradientColor2 = this.gradientColor2.mixWith(nc2, sin);
        }
    }

    @Override
    public void doRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.doRender(graphics, mouseX, mouseY, partialTicks);
        float fadeValue = this.fade.getValue();
        if (fadeValue < 0.1f) {
            return;
        }
        if (this.shortcut != null) {
            class_4587 ms = graphics.method_51448();
            ms.method_22903();
            ms.method_46416(0.0f, 0.0f, this.z + 10.0f);
            graphics.method_27534(class_310.method_1551().field_1772, this.shortcut.method_16007(), this.method_46426() + this.field_22758 / 2 + 8, this.method_46427() + this.field_22759 - 6, Theme.c(Theme.Key.TEXT_DARKER).scaleAlpha(fadeValue).getRGB());
            ms.method_22909();
        }
    }

    public class_1799 getItem() {
        return this.item;
    }

    public PonderTag getTag() {
        return this.tag;
    }

    @Override
    public Theme.Key getDisabledTheme() {
        return Theme.Key.PONDER_BUTTON_DISABLE;
    }

    @Override
    public Theme.Key getIdleTheme() {
        return Theme.Key.PONDER_BUTTON_IDLE;
    }

    @Override
    public Theme.Key getHoverTheme() {
        return Theme.Key.PONDER_BUTTON_HOVER;
    }

    @Override
    public Theme.Key getClickTheme() {
        return Theme.Key.PONDER_BUTTON_CLICK;
    }
}

