/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.copycat;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.foundation.utility.Iterate;
import io.github.fabricators_of_create.porting_lib.models.CustomParticleIconModel;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_5819;

public abstract class CopycatModel
extends ForwardingBakedModel
implements CustomParticleIconModel {
    public CopycatModel(class_1087 originalModel) {
        this.wrapped = originalModel;
    }

    private void gatherOcclusionData(class_1920 world, class_2338 pos, class_2680 state, class_2680 material, OcclusionData occlusionData, CopycatBlock copycatBlock) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (class_2350 face : Iterate.directions) {
            class_2338.class_2339 neighbourPos;
            if (!copycatBlock.canFaceBeOccluded(state, face) || class_2248.method_9607((class_2680)material, (class_1922)world, (class_2338)pos, (class_2350)face, (class_2338)(neighbourPos = mutablePos.method_25505((class_2382)pos, face)))) continue;
            occlusionData.occlude(face);
        }
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        boolean shouldTransform;
        class_2680 material1;
        RenderAttachedBlockView attachmentView;
        Object object;
        class_2680 material = blockView instanceof RenderAttachedBlockView && (object = (attachmentView = (RenderAttachedBlockView)blockView).getBlockEntityRenderAttachment(pos)) instanceof class_2680 ? (material1 = (class_2680)object) : AllBlocks.COPYCAT_BASE.getDefaultState();
        OcclusionData occlusionData = new OcclusionData();
        object = state.method_26204();
        if (object instanceof CopycatBlock) {
            CopycatBlock copycatBlock = (CopycatBlock)object;
            this.gatherOcclusionData(blockView, pos, state, material, occlusionData, copycatBlock);
        }
        CullFaceRemovalData cullFaceRemovalData = new CullFaceRemovalData();
        class_2350[] class_2350Array = state.method_26204();
        if (class_2350Array instanceof CopycatBlock) {
            CopycatBlock copycatBlock = (CopycatBlock)class_2350Array;
            for (class_2350 cullFace : Iterate.directions) {
                if (!copycatBlock.shouldFaceAlwaysRender(state, cullFace)) continue;
                cullFaceRemovalData.remove(cullFace);
            }
        }
        boolean bl = shouldTransform = material != AllBlocks.COPYCAT_BASE.getDefaultState();
        if (shouldTransform) {
            context.pushTransform((RenderContext.QuadTransform)MaterialFixer.create(material));
        }
        this.emitBlockQuadsInner(blockView, state, pos, randomSupplier, context, material, cullFaceRemovalData, occlusionData);
        if (shouldTransform) {
            context.popTransform();
        }
    }

    protected abstract void emitBlockQuadsInner(class_1920 var1, class_2680 var2, class_2338 var3, Supplier<class_5819> var4, RenderContext var5, class_2680 var6, CullFaceRemovalData var7, OcclusionData var8);

    public class_1058 getParticleIcon(Object data) {
        if (data instanceof class_2680) {
            class_2680 state = (class_2680)data;
            class_2680 material = CopycatModel.getMaterial(state);
            return CopycatModel.getIcon(CopycatModel.getModelOf(material), null);
        }
        return super.getParticleIcon(data);
    }

    public static class_1058 getIcon(class_1087 model, @Nullable Object data) {
        if (model instanceof CustomParticleIconModel) {
            CustomParticleIconModel particleIconModel = (CustomParticleIconModel)model;
            return particleIconModel.getParticleIcon(data);
        }
        return model.method_4711();
    }

    @Nullable
    public static class_2680 getMaterial(class_2680 material) {
        return material == null ? AllBlocks.COPYCAT_BASE.getDefaultState() : material;
    }

    public static class_1087 getModelOf(class_2680 state) {
        return class_310.method_1551().method_1541().method_3349(state);
    }

    protected static class OcclusionData {
        private final boolean[] occluded = new boolean[6];

        public void occlude(class_2350 face) {
            this.occluded[face.method_10146()] = true;
        }

        public boolean isOccluded(class_2350 face) {
            return face == null ? false : this.occluded[face.method_10146()];
        }
    }

    protected static class CullFaceRemovalData {
        private final boolean[] shouldRemove = new boolean[6];

        public void remove(class_2350 face) {
            this.shouldRemove[face.method_10146()] = true;
        }

        public boolean shouldRemove(class_2350 face) {
            return face == null ? false : this.shouldRemove[face.method_10146()];
        }
    }

    private record MaterialFixer(RenderMaterial materialDefault) implements RenderContext.QuadTransform
    {
        public boolean transform(MutableQuadView quad) {
            if (quad.material().blendMode() == BlendMode.DEFAULT) {
                quad.material(this.materialDefault);
            }
            return true;
        }

        public static MaterialFixer create(class_2680 materialState) {
            class_1921 type = class_4696.method_23679((class_2680)materialState);
            BlendMode blendMode = BlendMode.fromRenderLayer((class_1921)type);
            MaterialFinder finder = Objects.requireNonNull(RendererAccess.INSTANCE.getRenderer()).materialFinder();
            RenderMaterial renderMaterial = finder.blendMode(0, blendMode).find();
            return new MaterialFixer(renderMaterial);
        }
    }
}

