/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable;

import artifacts.item.wearable.WearableArtifactItem;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class MobEffectItem
extends WearableArtifactItem {
    private final class_1291 mobEffect;
    private final int duration;
    protected final Supplier<Integer> amplifier;
    protected final Supplier<Boolean> isEnabled;

    public MobEffectItem(class_1291 mobEffect, Supplier<Boolean> isEnabled) {
        this(mobEffect, () -> 1, 40, isEnabled);
    }

    public MobEffectItem(class_1291 mobEffect, int duration, Supplier<Boolean> isEnabled) {
        this(mobEffect, () -> 1, duration, isEnabled);
    }

    public MobEffectItem(class_1291 mobEffect, Supplier<Integer> amplifier, int duration) {
        this(mobEffect, amplifier, duration, () -> true);
    }

    private MobEffectItem(class_1291 mobEffect, Supplier<Integer> amplifier, int duration, Supplier<Boolean> isEnabled) {
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.isEnabled = isEnabled;
    }

    @Override
    protected boolean hasNonCosmeticEffects() {
        return this.isEnabled.get() != false && this.amplifier.get() > 0;
    }

    public boolean isEffectActive(class_1309 entity) {
        if (!this.isEnabled.get().booleanValue() || this.amplifier.get() == 0) {
            return false;
        }
        return this.findAllEquippedBy(entity).anyMatch(WearableArtifactItem::isActivated);
    }

    private int getAmplifier() {
        return this.amplifier.get() - 1;
    }

    protected int getDuration(class_1309 entity) {
        return this.duration;
    }

    @Nullable
    protected class_1309 getTarget(class_1309 entity) {
        return entity;
    }

    protected boolean shouldShowIcon() {
        return false;
    }

    protected boolean shouldShowParticles() {
        return false;
    }

    protected int getUpdateInterval() {
        return 1;
    }

    @Override
    public void wornTick(class_1309 entity, class_1799 stack) {
        class_1309 target;
        if (this.isEffectActive(entity) && !entity.method_37908().method_8608() && (target = this.getTarget(entity)) != null && entity.field_6012 % this.getUpdateInterval() == 0) {
            target.method_6092(new class_1293(this.mobEffect, this.getDuration(target) - 1, this.getAmplifier(), false, this.shouldShowParticles(), this.shouldShowIcon()));
        }
    }

    @Override
    public void onUnequip(class_1309 entity, class_1799 stack) {
        this.removeRemainingEffect(entity);
    }

    private void removeRemainingEffect(class_1309 entity) {
        class_1293 effectInstance;
        if (this.isEnabled.get().booleanValue() && !entity.method_37908().method_8608() && this.getTarget(entity) == entity && (effectInstance = entity.method_6112(this.mobEffect)) != null && effectInstance.method_5578() == this.getAmplifier() && !effectInstance.method_5581() && effectInstance.method_5584() < this.getDuration(entity)) {
            entity.method_6016(this.mobEffect);
        }
    }

    @Override
    public void toggleItem(class_3222 player) {
        super.toggleItem(player);
        if (!this.isEffectActive((class_1309)player)) {
            this.removeRemainingEffect((class_1309)player);
        }
    }
}

