/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.client.AdAstraClient;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.blockentities.machines.OxygenLoaderBlockEntity;
import earth.terrarium.adastra.common.blocks.machines.GravityNormalizerBlock;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.container.BiFluidContainer;
import earth.terrarium.adastra.common.entities.AirVortex;
import earth.terrarium.adastra.common.menus.machines.OxygenDistributorMenu;
import earth.terrarium.adastra.common.recipes.machines.OxygenLoadingRecipe;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.adastra.common.utils.floodfill.FloodFill3D;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class OxygenDistributorBlockEntity
extends OxygenLoaderBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_SLOTS), new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY), new ConfigurationEntry(ConfigurationType.FLUID, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_FLUID), new ConfigurationEntry(ConfigurationType.FLUID, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_FLUID));
    private final Set<class_2338> lastDistributedBlocks = new HashSet<class_2338>();
    private long energyPerTick;
    private float fluidPerTick;
    private int distributedBlocksCount;
    private double accumulatedFluid;
    private int shutDownTicks;
    private int limit = MachineConfig.maxDistributionBlocks;
    private boolean shouldSyncPositions;
    private float yRot;
    private float lastYRot;

    public OxygenDistributorBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, 3);
    }

    @Override
    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("LastDistributedBlocks")) {
            this.lastDistributedBlocks.clear();
            for (long pos : tag.method_10565("LastDistributedBlocks")) {
                this.lastDistributedBlocks.add(class_2338.method_10092((long)pos));
            }
        }
        this.energyPerTick = tag.method_10537("EnergyPerTick");
        this.fluidPerTick = tag.method_10583("FluidPerTick");
        this.distributedBlocksCount = tag.method_10550("DistributedBlocksCount");
        this.accumulatedFluid = tag.method_10574("AccumulatedFluid");
        this.limit = tag.method_10550("Limit");
    }

    @Override
    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10544("EnergyPerTick", this.energyPerTick);
        tag.method_10548("FluidPerTick", this.fluidPerTick);
        tag.method_10569("DistributedBlocksCount", this.distributedBlocksCount);
        tag.method_10549("AccumulatedFluid", this.accumulatedFluid);
        tag.method_10569("Limit", this.limit);
    }

    @Override
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new OxygenDistributorMenu(id, inventory, this);
    }

    @Override
    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((class_2586)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachineConfig.deshTierEnergyCapacity, MachineConfig.deshTierMaxEnergyInOut));
        return this.energyContainer;
    }

    @Override
    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        super.serverTick(level, time, state, pos);
        if (this.shutDownTicks > 0) {
            --this.shutDownTicks;
            return;
        }
        long fluidPerTick = this.calculateFluidPerTick();
        boolean canDistribute = this.canCraftDistribution(Math.max(FluidConstants.fromMillibuckets((long)1L), fluidPerTick));
        if (this.canFunction() && canDistribute) {
            this.getEnergyStorage().internalExtract(this.calculateEnergyPerTick(), false);
            this.setLit(true);
            this.accumulatedFluid += (double)fluidPerTick;
            int wholeBuckets = (int)(this.accumulatedFluid / 1000.0);
            if (wholeBuckets > 0) {
                this.consumeDistribution(FluidConstants.fromMillibuckets((long)Math.max(1, wholeBuckets / 1000)));
                this.accumulatedFluid -= (double)wholeBuckets;
            }
            if (time % (long)MachineConfig.distributionRefreshRate == 0L) {
                this.tickOxygen(level, pos, state);
            }
            if (time % 200L == 0L) {
                level.method_8396(null, pos, (class_3414)ModSoundEvents.OXYGEN_OUTTAKE.get(), class_3419.field_15245, 0.2f, 1.0f);
            } else if (time % 100L == 0L) {
                level.method_8396(null, pos, (class_3414)ModSoundEvents.OXYGEN_INTAKE.get(), class_3419.field_15245, 0.2f, 1.0f);
            }
        } else if (!this.lastDistributedBlocks.isEmpty()) {
            this.clearOxygenBlocks();
            this.shutDownTicks = 60;
            this.setLit(false);
        } else if (time % 10L == 0L) {
            this.setLit(false);
        }
        this.energyPerTick = (long)(this.recipe != null && this.canCraft() ? ((OxygenLoadingRecipe)this.recipe).energy() : 0) + (canDistribute ? this.calculateEnergyPerTick() : 0L);
        this.fluidPerTick = canDistribute ? (float)fluidPerTick : 0.0f;
        this.distributedBlocksCount = canDistribute ? this.lastDistributedBlocks.size() : 0;
    }

    @Override
    public void tickSideInteractions(class_2338 pos, Predicate<class_2350> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pullItemsNearby(this, pos, new int[]{1}, sideConfig.get(0), filter);
        TransferUtils.pushItemsNearby(this, pos, new int[]{2}, sideConfig.get(1), filter);
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(2), filter);
        TransferUtils.pullFluidNearby(this, pos, this.getFluidContainer(), FluidConstants.fromMillibuckets((long)200L), 0, sideConfig.get(3), filter);
        TransferUtils.pushFluidNearby(this, pos, this.getFluidContainer(), FluidConstants.fromMillibuckets((long)200L), 1, sideConfig.get(4), filter);
    }

    @Override
    public void onRemoved() {
        this.clearOxygenBlocks();
    }

    private boolean canCraftDistribution(long fluidAmount) {
        long energy = this.calculateEnergyPerTick();
        if (this.getEnergyStorage().internalExtract(energy, true) < energy) {
            return false;
        }
        return ((BiFluidContainer)this.getFluidContainer().container()).output().internalExtract(((FluidHolder)this.getFluidContainer().getFluids().get(1)).copyWithAmount(fluidAmount), true).getFluidAmount() >= fluidAmount;
    }

    protected void consumeDistribution(long fluidAmount) {
        ((BiFluidContainer)this.getFluidContainer().container()).output().internalExtract(((FluidHolder)this.getFluidContainer().getFluids().get(1)).copyWithAmount(fluidAmount), false);
    }

    protected void tickOxygen(class_3218 level, class_2338 pos, class_2680 state) {
        this.limit = MachineConfig.maxDistributionBlocks;
        class_2350 offset = switch ((class_2738)state.method_11654((class_2769)GravityNormalizerBlock.FACE)) {
            case class_2738.field_12475 -> class_2350.field_11036;
            case class_2738.field_12473 -> class_2350.field_11033;
            default -> (class_2350)state.method_11654((class_2769)GravityNormalizerBlock.FACING);
        };
        Set<class_2338> positions = FloodFill3D.run((class_1937)level, pos.method_10093(offset), this.limit, FloodFill3D.TEST_FULL_SEAL, true);
        OxygenApi.API.setOxygen((class_1937)level, positions, true);
        TemperatureApi.API.setTemperature((class_1937)level, positions, (short)22);
        HashSet<class_2338> lastPositionsCopy = new HashSet<class_2338>(this.lastDistributedBlocks);
        this.resetLastDistributedBlocks(positions);
        if (AdAstraConfig.disableAirVortexes) {
            return;
        }
        if (positions.size() < this.limit) {
            return;
        }
        if (lastPositionsCopy.size() >= this.limit) {
            return;
        }
        if (OxygenApi.API.hasOxygen((class_1937)level)) {
            return;
        }
        positions.removeAll(lastPositionsCopy);
        class_2338 target = positions.stream().skip(1L).findFirst().orElse(positions.stream().findFirst().orElse(null));
        if (target == null) {
            return;
        }
        AirVortex vortex = new AirVortex((class_1937)level, pos, lastPositionsCopy);
        vortex.method_33574(class_243.method_24953((class_2382)target));
        level.method_8649((class_1297)vortex);
    }

    protected void resetLastDistributedBlocks(Set<class_2338> positions) {
        this.lastDistributedBlocks.removeAll(positions);
        this.clearOxygenBlocks();
        this.lastDistributedBlocks.addAll(positions);
        this.shouldSyncPositions = true;
    }

    protected void clearOxygenBlocks() {
        OxygenApi.API.removeOxygen(this.field_11863, this.lastDistributedBlocks);
        TemperatureApi.API.removeTemperature(this.field_11863, this.lastDistributedBlocks);
        this.lastDistributedBlocks.clear();
    }

    @Override
    public void updateSlots() {
        FluidUtils.moveItemToContainer(this, (FluidContainer)this.getFluidContainer(), 1, 2, 0);
        this.sync();
    }

    @Override
    public void clientTick(class_638 level, long time, class_2680 state, class_2338 pos) {
        if (time % 40L == 0L) {
            if (AdAstraConfigClient.showOxygenDistributorArea) {
                AdAstraClient.OXYGEN_OVERLAY_RENDERER.removePositions(pos);
                if (AdAstraClient.OXYGEN_OVERLAY_RENDERER.canAdd(pos) && this.canFunction() && this.canCraftDistribution(FluidConstants.fromMillibuckets((long)Math.max(1L, this.calculateFluidPerTick() / 1000L)))) {
                    AdAstraClient.OXYGEN_OVERLAY_RENDERER.addPositions(pos, this.lastDistributedBlocks);
                }
            } else {
                AdAstraClient.OXYGEN_OVERLAY_RENDERER.clearPositions();
            }
        }
        this.lastYRot = this.yRot;
        if (this.isLit()) {
            this.yRot += 10.0f;
        }
    }

    @Override
    public boolean shouldAutomaticallyUpdateLitState() {
        return false;
    }

    public int distributedBlocksCount() {
        return this.canFunction() ? this.distributedBlocksCount : 0;
    }

    public int distributedBlocksLimit() {
        return this.limit;
    }

    public long energyPerTick() {
        return this.canFunction() ? this.energyPerTick : 0L;
    }

    public float fluidPerTick() {
        return this.canFunction() ? this.fluidPerTick : 0.0f;
    }

    public float yRot() {
        return this.yRot;
    }

    public float lastYRot() {
        return this.lastYRot;
    }

    private long calculateEnergyPerTick() {
        return Math.max(1, this.lastDistributedBlocks.size() / 50);
    }

    private long calculateFluidPerTick() {
        return FluidConstants.fromMillibuckets((long)Math.max(1, this.lastDistributedBlocks.size() / 1500));
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    @Override
    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return new int[]{1, 2};
    }

    @Override
    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        if (this.shouldSyncPositions) {
            tag.method_10564("LastDistributedBlocks", this.lastDistributedBlocks.stream().mapToLong(class_2338::method_10063).toArray());
            this.shouldSyncPositions = false;
        }
        return tag;
    }
}

