/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_8053;
import net.minecraft.class_8055;
import net.minecraft.class_8057;
import net.minecraft.class_8059;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DefaultSmithingDisplay
extends BasicDisplay {
    @Nullable
    private final SmithingRecipeType type;

    @ApiStatus.Experimental
    public DefaultSmithingDisplay(class_8060 recipe) {
        this((class_8059)recipe, List.of(EntryIngredients.ofIngredient(recipe.field_42030), EntryIngredients.ofIngredient(recipe.field_42031), EntryIngredients.ofIngredient(recipe.field_42032)));
    }

    @Deprecated(forRemoval=true)
    public DefaultSmithingDisplay(class_8062 recipe) {
        this((class_8059)recipe, List.of(EntryIngredients.ofIngredient(recipe.field_42035), EntryIngredients.ofIngredient(recipe.field_42036), EntryIngredients.ofIngredient(recipe.field_42037)));
    }

    @ApiStatus.Experimental
    public static List<DefaultSmithingDisplay> from(class_8062 recipe) {
        class_5455 registryAccess = BasicDisplay.registryAccess();
        ArrayList<DefaultSmithingDisplay> displays = new ArrayList<DefaultSmithingDisplay>();
        for (class_1799 templateItem : recipe.field_42035.method_8105()) {
            class_6880.class_6883 trimPattern = class_8057.method_48448((class_5455)registryAccess, (class_1799)templateItem).orElse(null);
            if (trimPattern == null) continue;
            for (class_1799 additionStack : recipe.field_42037.method_8105()) {
                class_6880.class_6883 trimMaterial = class_8055.method_48440((class_5455)registryAccess, (class_1799)additionStack).orElse(null);
                if (trimMaterial == null) continue;
                EntryIngredient baseIngredient = EntryIngredients.ofIngredient(recipe.field_42036);
                EntryIngredient templateOutput = baseIngredient.isEmpty() ? EntryIngredient.empty() : DefaultSmithingDisplay.getTrimmingOutput(registryAccess, EntryStacks.of(templateItem), (EntryStack)baseIngredient.get(0), EntryStacks.of(additionStack));
                displays.add(new DefaultSmithingDisplay(List.of(EntryIngredients.of(templateItem), baseIngredient, EntryIngredients.of(additionStack)), List.of(templateOutput), SmithingRecipeType.TRIM, Optional.ofNullable(recipe.method_8114())));
            }
        }
        return displays;
    }

    public DefaultSmithingDisplay(class_8059 recipe, List<EntryIngredient> inputs) {
        this(inputs, List.of(EntryIngredients.of(recipe.method_8110(BasicDisplay.registryAccess()))), Optional.ofNullable(recipe.method_8114()));
    }

    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location) {
        this(inputs, outputs, null, location);
    }

    @ApiStatus.Experimental
    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, @Nullable SmithingRecipeType type, Optional<class_2960> location) {
        super(inputs, outputs, location);
        this.type = type;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.SMITHING;
    }

    @ApiStatus.Experimental
    @Nullable
    public SmithingRecipeType getType() {
        return this.type;
    }

    public static BasicDisplay.Serializer<DefaultSmithingDisplay> serializer() {
        return BasicDisplay.Serializer.of((input, output, id, tag) -> {
            SmithingRecipeType type = tag.method_10545("Type") ? SmithingRecipeType.valueOf(tag.method_10558("Type")) : null;
            return new DefaultSmithingDisplay(input, output, type, id);
        }, (display, tag) -> {
            if (display.type != null) {
                tag.method_10582("Type", display.type.name());
            }
        });
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static EntryIngredient getTrimmingOutput(class_5455 registryAccess, EntryStack<?> template, EntryStack<?> base, EntryStack<?> addition) {
        if (template.getType() != VanillaEntryTypes.ITEM || base.getType() != VanillaEntryTypes.ITEM || addition.getType() != VanillaEntryTypes.ITEM) {
            return EntryIngredient.empty();
        }
        class_1799 templateItem = (class_1799)template.castValue();
        class_1799 baseItem = (class_1799)base.castValue();
        class_1799 additionItem = (class_1799)addition.castValue();
        class_6880.class_6883 trimPattern = class_8057.method_48448((class_5455)registryAccess, (class_1799)templateItem).orElse(null);
        if (trimPattern == null) {
            return EntryIngredient.empty();
        }
        class_6880.class_6883 trimMaterial = class_8055.method_48440((class_5455)registryAccess, (class_1799)additionItem).orElse(null);
        if (trimMaterial == null) {
            return EntryIngredient.empty();
        }
        class_8053 armorTrim = new class_8053((class_6880)trimMaterial, (class_6880)trimPattern);
        Optional trim = class_8053.method_48428((class_5455)registryAccess, (class_1799)baseItem);
        if (trim.isPresent() && ((class_8053)trim.get()).method_48427((class_6880)trimPattern, (class_6880)trimMaterial)) {
            return EntryIngredient.empty();
        }
        class_1799 newItem = baseItem.method_7972();
        newItem.method_7939(1);
        if (class_8053.method_48429((class_5455)registryAccess, (class_1799)newItem, (class_8053)armorTrim)) {
            return EntryIngredients.of(newItem);
        }
        return EntryIngredient.empty();
    }

    @ApiStatus.Experimental
    public static enum SmithingRecipeType {
        TRIM,
        TRANSFORM;

    }
}

