/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueProvider;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

public final class LabelWidget
extends Label {
    private boolean hovered = false;
    private boolean focused = false;
    private boolean clickable = false;
    private int horizontalAlignment = 0;
    private boolean hasShadow = true;
    private boolean focusable = true;
    private ValueProvider<Color> color = ValueAnimator.ofColor().withConvention(() -> Color.ofTransparent((int)(REIRuntime.getInstance().isDarkThemeEnabled() ? -4473925 : -1)), 50L);
    private ValueProvider<Color> hoveredColor = ValueAnimator.ofColor().withConvention(() -> Color.ofTransparent((int)(REIRuntime.getInstance().isDarkThemeEnabled() ? -1 : -10027060)), 50L);
    private final ValueProvider<Color> finalColor = ValueAnimator.ofColor().withConvention(() -> {
        if (!this.hovered) {
            return (Color)this.color.value();
        }
        return (Color)this.hoveredColor.value();
    }, ValueAnimator.typicalTransitionTime() / 2L);
    private Point point;
    @Nullable
    private @Nullable Function<Label, @Nullable class_2561[]> tooltip;
    @Nullable
    private Consumer<Label> onClick;
    @Nullable
    private BiConsumer<class_332, Label> onRender;
    private class_5348 text;
    private boolean rainbow;
    private final LazyResettable<class_5481> orderedText = new LazyResettable(() -> class_2477.method_10517().method_30934(this.getMessage()));

    public LabelWidget(Point point, class_5348 text) {
        this.point = point;
        Objects.requireNonNull(this.point);
        this.text = text;
        Objects.requireNonNull(this.text);
    }

    @Override
    public final boolean isClickable() {
        return this.clickable;
    }

    @Override
    public final void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    @Override
    @Nullable
    public final Consumer<Label> getOnClick() {
        return this.onClick;
    }

    @Override
    public final void setOnClick(@Nullable Consumer<Label> onClick) {
        this.onClick = onClick;
    }

    @Override
    @Nullable
    public final BiConsumer<class_332, Label> getOnRender() {
        return this.onRender;
    }

    @Override
    public final void setOnRender(@Nullable BiConsumer<class_332, Label> onRender) {
        this.onRender = onRender;
    }

    @Override
    public final boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public final void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    @Nullable
    public final class_2561[] getTooltipLines() {
        if (this.tooltip == null) {
            return null;
        }
        return this.tooltip.apply(this);
    }

    @Override
    public final void setTooltipFunction(@Nullable @Nullable Function<Label, @Nullable class_2561[]> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public final int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public final void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public final boolean hasShadow() {
        return this.hasShadow;
    }

    @Override
    public final void setShadow(boolean hasShadow) {
        this.hasShadow = hasShadow;
    }

    @Override
    public final int getColor() {
        return ((Color)this.color.value()).getColor();
    }

    @Override
    public final void setColor(int color) {
        this.color = ValueProvider.constant((Object)Color.ofTransparent((int)color));
        this.finalColor.completeImmediately();
    }

    @Override
    public Label color(int lightModeColor, int darkModeColor) {
        this.color = ValueAnimator.ofColor().withConvention(() -> Color.ofTransparent((int)(REIRuntime.getInstance().isDarkThemeEnabled() ? darkModeColor : lightModeColor)), ValueAnimator.typicalTransitionTime());
        this.color.completeImmediately();
        this.finalColor.completeImmediately();
        return this;
    }

    @Override
    public final int getHoveredColor() {
        return ((Color)this.hoveredColor.value()).getColor();
    }

    @Override
    public final void setHoveredColor(int hoveredColor) {
        this.hoveredColor = ValueProvider.constant((Object)Color.ofTransparent((int)hoveredColor));
        this.finalColor.completeImmediately();
    }

    @Override
    public final Point getPoint() {
        return this.point;
    }

    @Override
    public final void setPoint(Point point) {
        this.point = Objects.requireNonNull(point);
    }

    @Override
    public class_5348 getMessage() {
        return this.text;
    }

    @Override
    public void setMessage(class_5348 message) {
        this.text = Objects.requireNonNull(message);
        this.orderedText.reset();
    }

    @Override
    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
    }

    @Override
    public final Rectangle getBounds() {
        int width = this.font.method_27525(this.text);
        Point point = this.getPoint();
        if (this.getHorizontalAlignment() == -1) {
            return new Rectangle(point.x - 1, point.y - 5, width + 2, 14);
        }
        if (this.getHorizontalAlignment() == 1) {
            return new Rectangle(point.x - width - 1, point.y - 5, width + 2, 14);
        }
        return new Rectangle(point.x - width / 2 - 1, point.y - 5, width + 2, 14);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        class_2561[] tooltip;
        this.color.update((double)delta);
        this.hoveredColor.update((double)delta);
        this.finalColor.update((double)delta);
        if (this.getOnRender() != null) {
            this.getOnRender().accept(graphics, this);
        }
        int color = ((Color)this.finalColor.value()).getColor();
        this.hovered = this.isClickable() && this.isHovered(mouseX, mouseY);
        Point pos = this.getPoint();
        class_5481 sequence = (class_5481)this.orderedText.get();
        if (this.rainbow) {
            sequence = TextTransformations.applyRainbow(sequence, pos.x, pos.y);
        }
        int width = this.font.method_30880(sequence);
        switch (this.getHorizontalAlignment()) {
            case -1: {
                graphics.method_51430(this.font, sequence, pos.x, pos.y, color, this.hasShadow());
                break;
            }
            case 1: {
                graphics.method_51430(this.font, sequence, pos.x - width, pos.y, color, this.hasShadow());
                break;
            }
            default: {
                graphics.method_51430(this.font, sequence, (int)((float)pos.x - (float)width / 2.0f), pos.y, color, this.hasShadow());
            }
        }
        if (this.isHovered(mouseX, mouseY) && (tooltip = this.getTooltipLines()) != null) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                Tooltip.create(tooltip).queue();
            } else if (this.focused) {
                Tooltip.create(this.point, tooltip).queue();
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isClickable() && this.containsMouse(mouseX, mouseY)) {
            Widgets.produceClickSound();
            if (this.onClick != null) {
                this.onClick.accept(this);
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (!(this.isClickable() && this.isFocusable() && this.focused)) {
            return false;
        }
        if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
            return false;
        }
        Widgets.produceClickSound();
        if (this.onClick != null) {
            this.onClick.accept(this);
        }
        return true;
    }

    @Nullable
    public class_8016 method_48205(class_8023 event) {
        return this.isClickable() && this.focusable ? class_8016.method_48193((class_364)this) : null;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return this.containsMouse(mouseX, mouseY) || this.focused;
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }
}

