/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.config;

import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import org.jetbrains.annotations.Nullable;

public class TooltipComponentConfig
implements ConfigCore {
    @Config(description={"Should this tooltip component be included when rendering held item tooltips."})
    public boolean include;
    @Config(description={"The order in which this tooltip component appears in relation to other components. Smaller values appear first."})
    public int ordering;
    @Config(description={"Priority for rendering this tooltip. When not enough lines are available (like an item with enchantments), components with a low priority will be skipped."})
    public int priority;
    @Config(description={"Represent information for this component as if advanced tooltips were enabled independently of the actual setting."})
    public boolean advancedTooltips;
    @Config(description={"Should this tooltip component be hidden when vanilla's respective \"HideFlags\" property is set."})
    public boolean respectHideFlags = true;
    @Config(description={"Text formatting settings for this component's text appearance."})
    private final FormattingConfig formatting;

    public static TooltipComponentConfig simple(boolean include, int ordering, int priority) {
        return TooltipComponentConfig.simple(include, ordering, priority, null);
    }

    public static TooltipComponentConfig simple(boolean include, int ordering, int priority, @Nullable class_124 textColor) {
        return new TooltipComponentConfig(include, ordering, priority, false, textColor);
    }

    public static TooltipComponentConfig advanced(boolean include, int ordering, int priority) {
        return new TooltipComponentConfig(include, ordering, priority, true, null);
    }

    private TooltipComponentConfig(boolean include, int ordering, int priority, boolean advancedTooltips, @Nullable class_124 textColor) {
        this.include = include;
        this.ordering = ordering;
        this.priority = priority;
        this.advancedTooltips = advancedTooltips;
        this.formatting = new FormattingConfig(textColor);
    }

    public class_2583 getStyle() {
        return FormattingConfig.toStyle(this.formatting);
    }

    private static class FormattingConfig
    implements ConfigCore {
        private static final String DEFAULT_FORMATTING = "default";
        @Config(name="text_color", description={"The color of this component's text."})
        @Config.AllowedValues(values={"default", "black", "dark_blue", "dark_green", "dark_aqua", "dark_red", "dark_purple", "gold", "gray", "dark_gray", "blue", "green", "aqua", "red", "light_purple", "yellow", "white"})
        String textColorRaw;
        @Config(description={"Should the text in this component be replaced by random characters."})
        public boolean obfuscated;
        @Config(description={"Should the text in this component appear bold."})
        public boolean bold;
        @Config(description={"Should the text in this component appear struck-through."})
        public boolean strikethrough;
        @Config(description={"Should the text in this component appear with an underline."})
        public boolean underline;
        @Config(description={"Should the text in this component appear italic."})
        public boolean italic;
        @Nullable
        public class_124 textColor;

        public FormattingConfig(@Nullable class_124 textColor) {
            this.textColorRaw = textColor == null ? DEFAULT_FORMATTING : textColor.method_15434();
        }

        public void afterConfigReload() {
            this.textColor = class_124.method_533((String)this.textColorRaw);
        }

        public static class_2583 toStyle(FormattingConfig formatting) {
            class_2583 style = class_2583.field_24360;
            if (formatting.textColor != null) {
                style = style.method_10977(formatting.textColor);
            }
            if (formatting.obfuscated) {
                style = style.method_36141(Boolean.valueOf(true));
            }
            if (formatting.bold) {
                style = style.method_10982(Boolean.valueOf(true));
            }
            if (formatting.strikethrough) {
                style = style.method_36140(Boolean.valueOf(true));
            }
            if (formatting.underline) {
                style = style.method_30938(Boolean.valueOf(true));
            }
            if (formatting.italic) {
                style = style.method_10978(Boolean.valueOf(true));
            }
            return style;
        }
    }
}

