/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.helditemtooltips.HeldItemTooltips;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.HoverTextManager;
import fuzs.helditemtooltips.config.ClientConfig;
import fuzs.helditemtooltips.mixin.client.accessor.GuiAccessor;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;

public class SelectedItemHandler {
    public static final SelectedItemHandler INSTANCE = new SelectedItemHandler();
    private int remainingHighlightTicks;
    private class_1799 highlightingItemStack = class_1799.field_8037;
    private int maxLines;

    public void onClientTick$End(class_310 minecraft) {
        if (minecraft.field_1724 == null || minecraft.method_1493()) {
            return;
        }
        class_1799 stack = minecraft.field_1724.method_31548().method_7391();
        if (!this.highlightingItemStack.method_7960() && class_1799.method_7984((class_1799)stack, (class_1799)this.highlightingItemStack) && stack.method_7964().equals(this.highlightingItemStack.method_7964())) {
            if (this.highlightingItemStack != stack) {
                this.highlightingItemStack = stack;
                HoverTextManager.reset();
            }
            if (this.remainingHighlightTicks > 0) {
                --this.remainingHighlightTicks;
            }
        } else {
            this.highlightingItemStack = stack;
            if (this.highlightingItemStack.method_7960()) {
                this.remainingHighlightTicks = 0;
            } else {
                this.remainingHighlightTicks = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayTime;
                HoverTextManager.reset();
            }
        }
    }

    public EventResult onRenderGuiOverlay$ItemName(class_310 minecraft, class_332 guiGraphics, float tickDelta, int screenWidth, int screenHeight) {
        int alpha;
        if (this.highlightingItemStack.method_7960()) {
            return EventResult.INTERRUPT;
        }
        minecraft.method_16011().method_15396("selectedItemName");
        int n = alpha = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayTime == 0 ? 255 : (int)Math.min(255.0f, (float)this.remainingHighlightTicks * 255.0f / 10.0f);
        if (alpha <= 0) {
            return EventResult.INTERRUPT;
        }
        List<class_2561> lines = this.getTooltipLines(minecraft);
        float currentScale = (float)((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayScale / 6.0f;
        int posX = this.getPosX(currentScale, screenWidth);
        int posY = this.getPosY(currentScale, screenHeight, lines.size(), minecraft);
        class_327 font = minecraft.field_1772;
        guiGraphics.method_51448().method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_51448().method_22905(currentScale, currentScale, 1.0f);
        this.drawBackground(guiGraphics, posX, posY, alpha, lines, minecraft);
        for (int i = 0; i < lines.size(); ++i) {
            int n2;
            class_2561 component = lines.get(i);
            guiGraphics.method_27534(font, component, posX, posY, 0xFFFFFF + (alpha << 24));
            if (i == 0) {
                Objects.requireNonNull(font);
                n2 = 9 + 3;
            } else {
                Objects.requireNonNull(font);
                n2 = 9 + 1;
            }
            posY += n2;
        }
        guiGraphics.method_51448().method_22905(1.0f / currentScale, 1.0f / currentScale, 1.0f);
        RenderSystem.disableBlend();
        guiGraphics.method_51448().method_22909();
        minecraft.method_16011().method_15407();
        return EventResult.INTERRUPT;
    }

    private int getPosX(float currentScale, int screenWidth) {
        int posX = (int)((float)screenWidth / (2.0f * currentScale));
        return posX += ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).offsetX;
    }

    private int getPosY(float currentScale, int screenHeight, int allLines, class_310 minecraft) {
        int posY = (int)((float)screenHeight / currentScale);
        posY = (int)((float)posY - (float)((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).offsetY / currentScale);
        if (!minecraft.field_1761.method_2908()) {
            posY += 14;
        }
        return posY -= allLines > 1 ? (allLines - 1) * 10 + 2 : (allLines - 1) * 10;
    }

    private List<class_2561> getTooltipLines(class_310 minecraft) {
        int maxLines;
        ClientConfig clientConfig = (ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class);
        if (clientConfig.itemBlacklist.contains((Object)this.highlightingItemStack.method_7909())) {
            maxLines = 1;
        } else {
            int overlayMessageTime = ((GuiAccessor)minecraft.field_1705).helditemtooltips$getOverlayMessageTime();
            int n = overlayMessageTime > 0 ? (minecraft.field_1761.method_2908() ? 1 : 2) : (maxLines = clientConfig.maxLines);
        }
        if ((clientConfig.displayTime - this.remainingHighlightTicks) % clientConfig.updateInterval == 0 || this.maxLines != maxLines) {
            HoverTextManager.reset();
        }
        this.maxLines = maxLines;
        return HoverTextManager.getTooltipLines(this.highlightingItemStack, (class_1657)minecraft.field_1724, this.maxLines);
    }

    private void drawBackground(class_332 guiGraphics, int posX, int posY, int alpha, List<class_2561> lines, class_310 minecraft) {
        ClientConfig.HoverTextBackground background = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).background;
        class_327 font = minecraft.field_1772;
        alpha = (int)((double)alpha * (Double)minecraft.field_1690.method_42550().method_41753());
        if (background == ClientConfig.HoverTextBackground.RECTANGLE) {
            int maximumWidth = lines.stream().mapToInt(arg_0 -> ((class_327)font).method_27525(arg_0)).max().orElse(0) / 2;
            int size = lines.size();
            Objects.requireNonNull(font);
            guiGraphics.method_25294(posX - maximumWidth - 2, posY - 2, posX + maximumWidth + 2, posY + size * (9 + 1) + (size > 1 ? 1 : -1) + 2, alpha << 24);
        } else if (background == ClientConfig.HoverTextBackground.ADAPTIVE) {
            for (int i = 0; i < lines.size(); ++i) {
                int n;
                int top;
                int previousWidth = SelectedItemHandler.textWidth(font, lines, i - 1) / 2;
                int currentWidth = SelectedItemHandler.textWidth(font, lines, i) / 2;
                int nextWidth = SelectedItemHandler.textWidth(font, lines, i + 1) / 2;
                int n2 = currentWidth < previousWidth ? (i == 1 ? 1 : -1) : (top = 2);
                int bottom = currentWidth <= nextWidth ? (i == 0 ? 1 : -1) : 2;
                Objects.requireNonNull(font);
                guiGraphics.method_25294(posX - currentWidth - 2, posY - top, posX + currentWidth + 2, posY + 9 + bottom, alpha << 24);
                if (i == 0) {
                    Objects.requireNonNull(font);
                    n = 9 + 3;
                } else {
                    Objects.requireNonNull(font);
                    n = 9 + 1;
                }
                posY += n;
            }
        }
    }

    private static int textWidth(class_327 font, List<class_2561> lines, int index) {
        int clampedIndex = class_3532.method_15340((int)index, (int)0, (int)(lines.size() - 1));
        return clampedIndex == index ? font.method_27525((class_5348)lines.get(index)) : 0;
    }
}

