/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.gui.screens.inventory.tooltip;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponent;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponents;
import fuzs.helditemtooltips.config.TooltipComponentConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class TooltipComponentHolder {
    private static final Map<TooltipComponent, class_1799.class_5422> TOOLTIP_COMPONENT_TO_PART = ImmutableMap.builder().put((Object)TooltipComponents.ENCHANTMENTS, (Object)class_1799.class_5422.field_25768).put((Object)TooltipComponents.MODIFIERS, (Object)class_1799.class_5422.field_25769).put((Object)TooltipComponents.UNBREAKABLE, (Object)class_1799.class_5422.field_25770).put((Object)TooltipComponents.ADDITIONAL, (Object)class_1799.class_5422.field_25773).put((Object)TooltipComponents.COLORING, (Object)class_1799.class_5422.field_25774).build();
    private final TooltipComponent component;
    private final TooltipComponentConfig settings;
    private List<class_2561> lines;
    private int maxLines = -1;

    public TooltipComponentHolder(TooltipComponent component, TooltipComponentConfig settings) {
        this.component = component;
        this.settings = settings;
    }

    public boolean include() {
        return this.settings.include;
    }

    public int ordering() {
        return this.settings.ordering;
    }

    public int priority() {
        return this.settings.priority;
    }

    public void clear() {
        this.lines = null;
    }

    public void tryRebuild(class_1799 stack, @Nullable class_1657 player) {
        if (this.lines == null || this.component.alwaysUpdate()) {
            if (!this.settings.respectHideFlags || TooltipComponentHolder.shouldShowInTooltip(stack, this.component)) {
                ArrayList lines = Lists.newArrayList((Object[])new class_2561[]{class_5244.field_39003});
                class_1836.class_1837 tooltipFlag = this.settings.advancedTooltips ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
                class_2583 style = this.settings.getStyle();
                this.component.appendTooltipLines(lines, stack, player, (class_1836)tooltipFlag, style);
                lines.removeIf(component -> component.getString().isEmpty());
                this.lines = Collections.unmodifiableList(lines);
            } else {
                this.lines = List.of();
            }
        }
    }

    public int subtractLines(int maxLines) {
        this.maxLines = Math.min(this.size(), Math.max(maxLines, 0));
        return maxLines - this.size();
    }

    public List<class_2561> getLines() {
        Objects.requireNonNull(this.lines, "lines is null");
        return this.lines.subList(0, this.maxLines);
    }

    public int size() {
        Objects.requireNonNull(this.lines, "lines is null");
        return this.lines.size();
    }

    private static boolean shouldShowInTooltip(class_1799 stack, TooltipComponent component) {
        if (!TOOLTIP_COMPONENT_TO_PART.containsKey(component)) {
            return true;
        }
        int hideFlags = stack.method_7985() && stack.method_7969().method_10573("HideFlags", 99) ? stack.method_7969().method_10550("HideFlags") : 0;
        return (hideFlags & TOOLTIP_COMPONENT_TO_PART.get(component).method_30269()) == 0;
    }
}

