/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.gui.screens.inventory.tooltip;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5134;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class ModifiersTooltipComponent
implements TooltipComponent {
    protected static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID BASE_ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    @Override
    public void appendTooltipLines(List<class_2561> lines, class_1799 stack, @Nullable class_1657 player, class_1836 tooltipFlag, class_2583 style) {
        ArrayList list = Lists.newArrayList();
        ModifiersTooltipComponent.addOldStyleAttributes(list, stack, player, 0);
        for (class_2561 component : list) {
            lines.add((class_2561)class_2561.method_43473().method_10852(component).method_27696(style.method_27702(component.method_10866())));
        }
    }

    private static void addOldStyleAttributes(List<class_2561> list, class_1799 stack, @Nullable class_1657 player, int startIndex) {
        Map<class_1304, Multimap<class_1320, class_1322>> map = ModifiersTooltipComponent.getSlotToAttributeMap(stack);
        if (map.size() == 1) {
            ArrayList tmpList = Lists.newArrayList();
            ModifiersTooltipComponent.addAttributesToTooltip(tmpList, player, stack, map.values().iterator().next());
            if (!tmpList.isEmpty()) {
                if (startIndex != 0) {
                    tmpList.add(0, class_2561.method_43473());
                }
                ModifiersTooltipComponent.addListToTooltip(list, tmpList, startIndex);
            }
        } else if (map.size() > 1) {
            int lastSize = 0;
            for (Map.Entry<class_1304, Multimap<class_1320, class_1322>> entry : map.entrySet()) {
                ArrayList tmpList = Lists.newArrayList();
                ModifiersTooltipComponent.addAttributesToTooltip(tmpList, player, stack, entry.getValue());
                if (tmpList.isEmpty()) continue;
                if (startIndex != 0) {
                    tmpList.add(0, class_2561.method_43473());
                }
                tmpList.add(1, class_2561.method_43471((String)("item.modifiers." + entry.getKey().method_5923())).method_27692(class_124.field_1080));
                ModifiersTooltipComponent.addListToTooltip(list, tmpList, startIndex + (lastSize += tmpList.size()));
            }
        }
    }

    private static void addListToTooltip(List<class_2561> list, List<class_2561> tmpList, int startIndex) {
        if (startIndex < list.size()) {
            list.addAll(startIndex, tmpList);
        } else {
            list.addAll(tmpList);
        }
    }

    private static Map<class_1304, Multimap<class_1320, class_1322>> getSlotToAttributeMap(class_1799 stack) {
        HashMap map = Maps.newHashMap();
        for (class_1304 equipmentslot : class_1304.values()) {
            Multimap multimap = stack.method_7926(equipmentslot);
            if (multimap.isEmpty()) continue;
            map.put(equipmentslot, multimap);
        }
        return map;
    }

    private static void addAttributesToTooltip(List<class_2561> list, @Nullable class_1657 player, class_1799 stack, Multimap<class_1320, class_1322> multimap) {
        for (Map.Entry entry : multimap.entries()) {
            class_1322 attributemodifier = (class_1322)entry.getValue();
            double d0 = attributemodifier.method_6186();
            boolean flag = false;
            if (player != null) {
                if (attributemodifier.method_6189().equals(BASE_ATTACK_DAMAGE_UUID)) {
                    d0 += player.method_26826(class_5134.field_23721);
                    d0 += (double)class_1890.method_8218((class_1799)stack, (class_1310)class_1310.field_6290);
                    flag = true;
                } else if (attributemodifier.method_6189().equals(BASE_ATTACK_SPEED_UUID)) {
                    d0 += player.method_26826(class_5134.field_23723);
                    flag = true;
                }
            }
            double d1 = attributemodifier.method_6182() != class_1322.class_1323.field_6330 && attributemodifier.method_6182() != class_1322.class_1323.field_6331 ? (((class_1320)entry.getKey()).equals(class_5134.field_23718) ? d0 * 10.0 : d0) : d0 * 100.0;
            if (flag && d0 != 0.0 || d0 > 0.0) {
                list.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + attributemodifier.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d1), class_2561.method_43471((String)((class_1320)entry.getKey()).method_26830())}).method_27692(class_124.field_1078));
                continue;
            }
            if (!(d0 < 0.0)) continue;
            list.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + attributemodifier.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d1 *= -1.0), class_2561.method_43471((String)((class_1320)entry.getKey()).method_26830())}).method_27692(class_124.field_1061));
        }
    }
}

