/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.gui.screens.inventory.tooltip;

import fuzs.helditemtooltips.HeldItemTooltips;
import fuzs.helditemtooltips.client.core.ClientAbstractions;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponent;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponentHolder;
import fuzs.helditemtooltips.config.ClientConfig;
import fuzs.helditemtooltips.config.TooltipComponentConfig;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class HoverTextManager {
    private static final List<TooltipComponentHolder> TOOLTIP_COMPONENT_HOLDERS = Lists.newArrayList();

    public static void register(TooltipComponent tooltipComponent, TooltipComponentConfig settings) {
        TOOLTIP_COMPONENT_HOLDERS.add(new TooltipComponentHolder(tooltipComponent, settings));
    }

    public static List<class_2561> getTooltipLines(class_1799 stack, @Nullable class_1657 player, int maxLines) {
        boolean includeLastLine;
        List<TooltipComponentHolder> holders = TOOLTIP_COMPONENT_HOLDERS.stream().filter(TooltipComponentHolder::include).collect(Collectors.toList());
        holders.forEach(holder -> holder.tryRebuild(stack, player));
        boolean bl = includeLastLine = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).lastLine && maxLines > 1;
        if (holders.stream().mapToInt(TooltipComponentHolder::size).sum() > maxLines && includeLastLine) {
            --maxLines;
        }
        holders.sort(Comparator.comparingInt(TooltipComponentHolder::priority).reversed());
        for (TooltipComponentHolder holder2 : holders) {
            maxLines = holder2.subtractLines(maxLines);
        }
        holders.sort(Comparator.comparingInt(TooltipComponentHolder::ordering));
        List<class_2561> lines = holders.stream().map(TooltipComponentHolder::getLines).flatMap(Collection::stream).collect(Collectors.toList());
        maxLines = HoverTextManager.applyAdditionalInformation(lines, stack, maxLines);
        if (includeLastLine && maxLines < 0) {
            lines.add((class_2561)class_2561.method_43469((String)"container.shulkerBox.more", (Object[])new Object[]{-1 * maxLines}).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        }
        return lines;
    }

    public static void reset() {
        TOOLTIP_COMPONENT_HOLDERS.forEach(TooltipComponentHolder::clear);
    }

    private static int applyAdditionalInformation(List<class_2561> lines, class_1799 stack, int maxLines) {
        if (!((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).additionalInformation) {
            return maxLines;
        }
        int oldSize = lines.size();
        ClientAbstractions.INSTANCE.getTooltipLines(stack, (class_1836)class_1836.class_1837.field_41070, lines);
        if (lines.size() - oldSize > Math.max(maxLines, 0)) {
            lines.subList(oldSize + Math.max(maxLines, 0), lines.size()).clear();
        }
        return maxLines - (lines.size() - oldSize);
    }
}

