/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.init;

import io.github.bumblesoftware.fastload.api.external.abstraction.core.handler.AbstractionFactory;
import io.github.bumblesoftware.fastload.api.external.abstraction.core.handler.AbstractionHandler;
import io.github.bumblesoftware.fastload.api.external.abstraction.core.versioning.VersionConstants;
import io.github.bumblesoftware.fastload.api.internal.abstraction.AbstractClientCalls;
import io.github.bumblesoftware.fastload.api.internal.abstraction.Client1182;
import io.github.bumblesoftware.fastload.client.FLClientEvents;
import io.github.bumblesoftware.fastload.client.FLClientHandler;
import io.github.bumblesoftware.fastload.config.DefaultConfig;
import io.github.bumblesoftware.fastload.config.FLConfig;
import io.github.bumblesoftware.fastload.config.FLMath;
import io.github.bumblesoftware.fastload.init.Fastload;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;

public class FastloadClient
implements ClientModInitializer {
    public static final AbstractionHandler<AbstractClientCalls> MINECRAFT_ABSTRACTION_HANDLER;

    public void onInitializeClient() {
    }

    private static String logKey(String key) {
        return key.toUpperCase() + ": ";
    }

    static {
        VersionConstants.init();
        MINECRAFT_ABSTRACTION_HANDLER = AbstractionFactory.create("Fastload", List.of("fastload-119-0-1-2-compat", "fastload-1193-compat", "fastload-1194-compat"), AbstractionHandler.Environment.CLIENT, event -> event.registerThreadUnsafe(0L, eventInstance -> event.stableArgs((eventContext, eventArgs) -> {
            if (VersionConstants.IS_MINECRAFT_1182) {
                if (FLMath.isDebugEnabled().booleanValue()) {
                    Fastload.LOGGER.info("Fastload 1.18.2 Base!");
                }
                eventContext.heldObj = new Client1182();
            }
        })));
        FLConfig.init();
        FLClientEvents.init();
        FLClientHandler.init();
        Fastload.LOGGER.info("Fastload Perceived Version: " + FastloadClient.MINECRAFT_ABSTRACTION_HANDLER.directory.getVersion());
        Fastload.LOGGER.info("Fastload Abstraction Supported Versions: " + FastloadClient.MINECRAFT_ABSTRACTION_HANDLER.directory.getSupportedVersionsNonArray());
        Fastload.LOGGER.info(FastloadClient.logKey("debug") + FLMath.isDebugEnabled().toString().toUpperCase());
        Fastload.LOGGER.info(FastloadClient.logKey("chunk_try_limit") + FLMath.getChunkTryLimit());
        Fastload.LOGGER.info(FastloadClient.logKey(DefaultConfig.LOCAL_RENDER_RADIUS_KEY) + FLMath.getLocalRenderChunkRadius());
        Fastload.LOGGER.info(FastloadClient.logKey(DefaultConfig.LOCAL_RENDER_AREA_KEY) + FLMath.getLocalRenderChunkArea());
        Fastload.LOGGER.info(FastloadClient.logKey(DefaultConfig.SERVER_RENDER_RADIUS_KEY) + FLMath.getServerRenderChunkRadius());
        Fastload.LOGGER.info(FastloadClient.logKey(DefaultConfig.SERVER_RENDER_AREA_KEY) + FLMath.getServerRenderChunkArea());
    }
}

