/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.client;

import io.github.bumblesoftware.fastload.api.internal.abstraction.AbstractClientCalls;
import io.github.bumblesoftware.fastload.client.BuildingTerrainScreen;
import io.github.bumblesoftware.fastload.client.FLClientEvents;
import io.github.bumblesoftware.fastload.common.FLCommonEvents;
import io.github.bumblesoftware.fastload.config.FLMath;
import io.github.bumblesoftware.fastload.init.Fastload;
import io.github.bumblesoftware.fastload.init.FastloadClient;
import io.github.bumblesoftware.fastload.util.TickTimer;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_434;
import net.minecraft.class_437;

public final class FLClientHandler {
    public static final AbstractClientCalls ABSTRACTED_CLIENT = (AbstractClientCalls)FastloadClient.MINECRAFT_ABSTRACTION_HANDLER.directory.getAbstractedEntries();
    private static class_437 oldCurrentScreen = null;
    private static boolean playerReady = false;
    private static boolean playerJoined = false;
    private static Integer oldChunkLoadedCountStorage = null;
    private static Integer oldChunkBuildCountStorage = null;
    private static int preparationWarnings = 0;
    private static int buildingWarnings = 0;
    public static final TickTimer CLIENT_TIMER = new TickTimer("minecraft_client;render_tick;");

    public static void init() {
        if (FLMath.isDebugEnabled().booleanValue()) {
            Fastload.LOGGER.info("FLClientHandler initialised");
        }
        FLClientHandler.registerEvents();
    }

    private static void log(String toLog) {
        Fastload.LOGGER.info(toLog);
    }

    private static void logRendering(int chunkLoadedCount) {
        if (ABSTRACTED_CLIENT.isSingleplayer()) {
            FLClientHandler.log("Goal (Loaded Chunks): " + FLMath.getLocalRenderChunkArea());
            FLClientHandler.log("Loaded Chunks: " + chunkLoadedCount);
        } else {
            FLClientHandler.log("Goal (Loaded Chunks): " + FLMath.getServerRenderChunkArea());
            FLClientHandler.log("Loaded Chunks: " + chunkLoadedCount);
        }
    }

    private static void logBuilding(int chunkBuildCount) {
        if (ABSTRACTED_CLIENT.isSingleplayer()) {
            FLClientHandler.log("Goal (Built Chunks): " + FLMath.getLocalRenderChunkArea());
            FLClientHandler.log("Chunk Build Count: " + chunkBuildCount);
        } else {
            FLClientHandler.log("Goal (Built Chunks): " + FLMath.getServerRenderChunkArea());
            FLClientHandler.log("Chunk Build Count: " + chunkBuildCount);
        }
    }

    private static void stopBuilding(int chunkLoadedCount, int chunkBuildCount) {
        if (playerJoined && playerReady) {
            System.gc();
            if (FLMath.isDebugEnabled().booleanValue()) {
                FLClientHandler.logBuilding(chunkBuildCount);
                FLClientHandler.logRendering(chunkLoadedCount);
            }
            if (!ABSTRACTED_CLIENT.isWindowFocused()) {
                CLIENT_TIMER.setTime(20);
                if (FLMath.isDebugEnabled().booleanValue()) {
                    FLClientHandler.log("Delaying PauseMenu until worldRendering initiates.");
                }
            }
            playerJoined = false;
            playerReady = false;
            oldChunkLoadedCountStorage = 0;
            oldChunkBuildCountStorage = 0;
            ABSTRACTED_CLIENT.getCurrentScreen().method_25419();
        }
    }

    private static void registerEvents() {
        FLCommonEvents.Events.EMPTY_EVENT.registerThreadUnsafe(1L, List.of("client_player;init;"), event -> event.stableArgs((eventContext, eventArgs) -> {
            if (FLMath.isDebugEnabled().booleanValue()) {
                Fastload.LOGGER.info("shouldLoad = true");
            }
            playerReady = true;
        }));
        FLClientEvents.Events.PLAYER_JOIN_EVENT.registerThreadUnsafe(1L, event -> event.stableArgs((eventContext, eventArgs) -> {
            if (FLMath.isDebugEnabled().booleanValue()) {
                Fastload.LOGGER.info("playerJoined = true");
            }
            playerJoined = true;
        }));
        FLClientEvents.Events.SET_SCREEN_EVENT.registerThreadUnsafe(1L, event -> event.stableArgs((eventContext, eventArgs) -> {
            if (CLIENT_TIMER.isReady() && ABSTRACTED_CLIENT.isGameMenuScreen(eventContext.screen()) && !ABSTRACTED_CLIENT.isWindowFocused()) {
                if (FLMath.isDebugEnabled().booleanValue()) {
                    FLClientHandler.log(Integer.toString(CLIENT_TIMER.getTime()));
                }
                eventContext.ci().cancel();
            }
        }));
        FLClientEvents.Events.SET_SCREEN_EVENT.registerThreadUnsafe(1L, event -> event.stableArgs((eventContext, eventArgs) -> {
            if (ABSTRACTED_CLIENT.isBuildingTerrainScreen(eventContext.screen()) && FLMath.isDebugEnabled().booleanValue()) {
                FLClientHandler.log("setScreen(new BuildingTerrainScreen)");
            }
        }));
        FLClientEvents.Events.SET_SCREEN_EVENT.registerThreadUnsafe(1L, event -> event.stableArgs((eventContext, eventArgs) -> {
            if (ABSTRACTED_CLIENT.isDownloadingTerrainScreen(eventContext.screen())) {
                if (FLMath.isDebugEnabled().booleanValue()) {
                    FLClientHandler.log("setScreen(new DownloadingTerrainScreen)");
                }
                if (playerReady && playerJoined && FLMath.isInstantLoadEnabled().booleanValue()) {
                    eventContext.ci().cancel();
                    ABSTRACTED_CLIENT.setScreen(null);
                    playerReady = false;
                    playerJoined = false;
                    CLIENT_TIMER.setTime(20);
                }
            }
        }));
        FLClientEvents.Events.SET_SCREEN_EVENT.registerThreadUnsafe(1L, List.of("level_loading_screen;441;redirect;"), event -> event.stableArgs((eventContext, eventArgs) -> {
            Boolean isPreRenderEnabled = FLMath.isLocalRenderEnabled();
            if (FLMath.isDebugEnabled().booleanValue()) {
                Fastload.LOGGER.info("isLocalRenderEnabled: " + isPreRenderEnabled);
                Fastload.LOGGER.info("localRenderChunkRadius: " + FLMath.getLocalRenderChunkRadius());
                Fastload.LOGGER.info("Fastload Perceived Render Distance: " + ABSTRACTED_CLIENT.getViewDistance());
            }
            if (isPreRenderEnabled.booleanValue()) {
                ABSTRACTED_CLIENT.setScreen(ABSTRACTED_CLIENT.newBuildingTerrainScreen(FLMath.getLocalRenderChunkArea()));
                if (FLMath.isDebugEnabled().booleanValue()) {
                    Fastload.LOGGER.info("LevelLoadingScreen -> BuildingTerrainScreen");
                    Fastload.LOGGER.info("Goal (Loaded Chunks): " + FLMath.getLocalRenderChunkArea());
                }
            } else {
                ABSTRACTED_CLIENT.setScreen((class_437)new class_434());
            }
        }));
        FLClientEvents.Events.SET_SCREEN_EVENT.registerThreadUnsafe(1L, List.of("client_player_network_handler;on_game_join;downloading_terrain_screen;redirect"), event -> event.stableArgs((eventContext, eventArgs) -> {
            if (ABSTRACTED_CLIENT.isSingleplayer()) {
                if (!FLMath.isLocalRenderEnabled().booleanValue()) {
                    ABSTRACTED_CLIENT.setScreen(eventContext.screen());
                }
            } else if (FLMath.isServerRenderEnabled().booleanValue()) {
                ABSTRACTED_CLIENT.setScreen(ABSTRACTED_CLIENT.newBuildingTerrainScreen(FLMath.getServerRenderChunkArea()));
            } else if (FLMath.isInstantLoadEnabled().booleanValue()) {
                ABSTRACTED_CLIENT.setScreen(null);
            } else {
                ABSTRACTED_CLIENT.setScreen(eventContext.screen());
            }
        }));
        FLClientEvents.Events.SET_SCREEN_EVENT.registerThreadUnsafe(1L, List.of("respawn_dts_redirect;"), event -> event.stableArgs((eventContext, eventArgs) -> {
            if (FLMath.isInstantLoadEnabled().booleanValue()) {
                ABSTRACTED_CLIENT.setScreen(null);
            } else {
                ABSTRACTED_CLIENT.setScreen(eventContext.screen());
            }
        }));
        FLClientEvents.Events.SET_SCREEN_EVENT.registerThreadUnsafe(1L, List.of("minecraft_client;join_world;progress_screen;redirect"), event -> event.stableArgs((eventContext, eventArgs) -> {
            if (ABSTRACTED_CLIENT.isSingleplayer()) {
                if (FLMath.isLocalRenderEnabled().booleanValue()) {
                    ABSTRACTED_CLIENT.reset(ABSTRACTED_CLIENT.getCurrentScreen());
                }
            } else if (FLMath.isServerRenderEnabled().booleanValue()) {
                ABSTRACTED_CLIENT.reset(ABSTRACTED_CLIENT.getCurrentScreen());
            } else {
                ABSTRACTED_CLIENT.reset(eventContext.screen());
            }
        }));
        FLCommonEvents.Events.BOOLEAN_EVENT.registerThreadUnsafe(1L, List.of("dts_tick;"), event -> event.stableArgs((eventContext, eventArgs) -> {
            eventContext.heldObj = true;
            if (FLMath.isDebugEnabled().booleanValue()) {
                Fastload.LOGGER.info("DownloadingTerrainScreen set to close on next render tick.");
            }
        }));
        FLCommonEvents.Events.BOOLEAN_EVENT.registerThreadUnsafe(1L, List.of("minecraft_client;render_tick;"), event -> event.stableArgs((eventContext, eventArgs) -> {
            if (ABSTRACTED_CLIENT.forCurrentScreen(ABSTRACTED_CLIENT::isBuildingTerrainScreen) && ABSTRACTED_CLIENT.getClientWorld() != null) {
                int chunkLoadedCount = ABSTRACTED_CLIENT.getLoadedChunkCount();
                int chunkBuildCount = ABSTRACTED_CLIENT.getCompletedChunkCount();
                int oldPreparationWarningCache = preparationWarnings;
                int oldBuildingWarningCache = buildingWarnings;
                int loadingAreaGoal = ((BuildingTerrainScreen)FLClientHandler.ABSTRACTED_CLIENT.getCurrentScreen()).loadingAreaGoal;
                if (FLMath.isDebugEnabled().booleanValue()) {
                    FLClientHandler.logRendering(chunkLoadedCount);
                    FLClientHandler.logBuilding(chunkBuildCount);
                }
                if (oldChunkLoadedCountStorage != null && oldChunkBuildCountStorage != null && chunkBuildCount > 0 && chunkLoadedCount > 0) {
                    if (oldChunkLoadedCountStorage == chunkLoadedCount) {
                        ++preparationWarnings;
                    }
                    if (oldChunkBuildCountStorage == chunkBuildCount) {
                        ++buildingWarnings;
                    }
                    if (buildingWarnings >= FLMath.getChunkTryLimit() || preparationWarnings >= FLMath.getChunkTryLimit()) {
                        buildingWarnings = 0;
                        preparationWarnings = 0;
                        FLClientHandler.log("Rendering is either taking too long or hit a roadblock. If you are in a server, this is potentially a limitation of the servers render distance and can be ignored.");
                        FLClientHandler.stopBuilding(chunkLoadedCount, chunkBuildCount);
                    }
                    int spamLimit = 2;
                    if (preparationWarnings > 0) {
                        if (oldPreparationWarningCache == preparationWarnings && preparationWarnings > 2) {
                            FLClientHandler.log("Same prepared chunk count returned " + preparationWarnings + " time(s) in a row!");
                            FLClientHandler.log("Had it be " + FLMath.getChunkTryLimit() + " time(s) in a row, rendering would've stopped");
                            if (FLMath.isDebugEnabled().booleanValue()) {
                                FLClientHandler.logRendering(chunkLoadedCount);
                            }
                        }
                        if (chunkLoadedCount > oldChunkLoadedCountStorage) {
                            preparationWarnings = 0;
                        }
                    }
                    if (buildingWarnings > 0) {
                        if (oldBuildingWarningCache == buildingWarnings && buildingWarnings > 2) {
                            FLClientHandler.log("Same built chunk count returned " + buildingWarnings + " time(s) in a row!");
                            FLClientHandler.log("Had it be " + FLMath.getChunkTryLimit() + " time(s) in a row, rendering would've stopped");
                            if (FLMath.isDebugEnabled().booleanValue()) {
                                FLClientHandler.logRendering(chunkLoadedCount);
                            }
                        }
                        if (chunkBuildCount > oldChunkBuildCountStorage) {
                            buildingWarnings = 0;
                        }
                    }
                }
                oldChunkLoadedCountStorage = chunkLoadedCount;
                oldChunkBuildCountStorage = chunkBuildCount;
                if (chunkLoadedCount >= loadingAreaGoal && chunkBuildCount >= loadingAreaGoal) {
                    FLClientHandler.stopBuilding(chunkLoadedCount, chunkBuildCount);
                    FLClientHandler.log("Successfully pre-loaded the world!");
                }
            }
        }));
        FLCommonEvents.Events.BOOLEAN_EVENT.registerThreadUnsafe(1L, List.of("minecraft_client;render_tick;"), event -> event.stableArgs((eventContext, eventArgs) -> {
            if (FLMath.isDebugEnabled().booleanValue()) {
                ABSTRACTED_CLIENT.forCurrentScreen(screen -> {
                    if (oldCurrentScreen != screen) {
                        oldCurrentScreen = screen;
                        Fastload.LOGGER.info("Screen changed to: " + screen);
                    }
                    return false;
                });
            }
        }));
        FLCommonEvents.Events.SERVER_EVENT.registerThreadUnsafe(1L, List.of("minecraft_server;prepare_start_region;is_loading;redirect"), event -> event.stableArgs((eventContext, eventArgs) -> {
            eventContext.returnValue().heldObj = true;
        }));
        FLCommonEvents.Events.RUNNABLE_EVENT.registerThreadUnsafe(1L, List.of("client_play_network_handler;on_resource_pack_send;execute_runnable;redirect"), event -> event.stableArgs((eventContext, eventArgs) -> {
            class_310 client = ABSTRACTED_CLIENT.getClientInstance();
            if (ABSTRACTED_CLIENT.forCurrentScreen(ABSTRACTED_CLIENT::isBuildingTerrainScreen)) {
                ((BuildingTerrainScreen)ABSTRACTED_CLIENT.getCurrentScreen()).setClose(() -> client.execute((Runnable)eventContext.heldObj));
            } else {
                client.execute((Runnable)eventContext.heldObj);
            }
        }));
        FLClientEvents.Events.BOX_BOOLEAN_EVENT.registerThreadUnsafe(1L, List.of("frustum_box_bool"), event -> FLClientEvents.Events.BOX_BOOLEAN_EVENT.stableArgs((eventContext, eventArgs) -> {
            block3: {
                block2: {
                    if (ABSTRACTED_CLIENT.forCurrentScreen(ABSTRACTED_CLIENT::isBuildingTerrainScreen)) break block2;
                    if (!ABSTRACTED_CLIENT.forCurrentScreen(ABSTRACTED_CLIENT::isDownloadingTerrainScreen)) break block3;
                }
                eventContext.cir().setReturnValue((Object)true);
            }
        }));
        FLCommonEvents.Events.INTEGER_EVENT.registerThreadUnsafe(1L, List.of("world_icon;"), event -> event.stableArgs((eventContext, eventArgs) -> {
            eventContext.heldObj = 100;
            if (FLMath.isDebugEnabled().booleanValue()) {
                Fastload.LOGGER.info("worldIcon time prolonged");
            }
        }));
    }
}

