/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.sounds;

import com.mojang.datafixers.util.Pair;
import dev.arbor.extrasoundsnext.ExtraSoundsNext;
import dev.arbor.extrasoundsnext.annotation.CategoryLoader;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_3419;

public final class SoundSouceInit {
    public static final Map<class_3419, class_3419> PARENTS = new HashMap<class_3419, class_3419>();
    public static final Map<String, class_3419> MASTERS = new HashMap<String, class_3419>();
    public static final Map<class_3419, Float> DEFAULT_LEVELS = new HashMap<class_3419, Float>();
    public static final Map<class_3419, Pair<Boolean, Boolean>> TOGGLEABLE_CATS = new HashMap<class_3419, Pair<Boolean, Boolean>>();
    public static final Map<class_3419, class_2561> TOOLTIPS = new HashMap<class_3419, class_2561>();
    public static final List<String> SUPPRESSED_NAMES = new ArrayList<String>();
    public static String[] MASTER_CLASSES;
    public static boolean IS_INITIALIZED;

    public static Pair<CategoryLoader, List<Field>> getCategories() {
        return Pair.of((Object)ExtraSoundsNext.MIXERS, SoundSouceInit.getRegistrations());
    }

    public static List<Field> getRegistrations() {
        return Arrays.stream(ExtraSoundsNext.MIXERS.getClass().getDeclaredFields()).filter(it -> it.isAnnotationPresent(CategoryLoader.Register.class)).toList();
    }

    public static String generateFieldClassName(Class<?> clazz, Field field) {
        return "%s#%s".formatted(clazz.getCanonicalName(), field.getName());
    }

    public static void initCategoryLoader() {
        if (IS_INITIALIZED) {
            return;
        }
        class_3419.field_15250.getClass().getClassLoader();
        try {
            Object object;
            String className;
            CategoryLoader.Register annotation;
            CategoryLoader categoryLoader;
            Pair<CategoryLoader, List<Field>> allAnnotations = SoundSouceInit.getCategories();
            for (Field field : (List)allAnnotations.getSecond()) {
                categoryLoader = (CategoryLoader)allAnnotations.getFirst();
                annotation = field.getAnnotation(CategoryLoader.Register.class);
                className = categoryLoader.getClass().getCanonicalName();
                object = field.get(categoryLoader);
                if (!(object instanceof class_3419)) {
                    String fieldClassName = SoundSouceInit.generateFieldClassName(categoryLoader.getClass(), field);
                    if (SUPPRESSED_NAMES.contains(fieldClassName)) continue;
                    ExtraSoundsNext.LOGGER.error("[%s] Cast check failed for the member '%s'.".formatted(ExtraSoundsNext.class.getSimpleName(), fieldClassName), (Throwable)new ClassCastException("Can not cast %s to SoundCategory".formatted(field.get(categoryLoader).getClass().getCanonicalName())));
                    SUPPRESSED_NAMES.add(fieldClassName);
                    continue;
                }
                class_3419 source = (class_3419)object;
                if (!annotation.master()) continue;
                if (MASTERS.containsKey(className)) {
                    if (!SUPPRESSED_NAMES.contains(className)) {
                        ExtraSoundsNext.LOGGER.warn("[%s] Unexpected annotation was found.".formatted(ExtraSoundsNext.class.getSimpleName()), (Throwable)new AnnotationFormatError("Class '%s' has a duplicate member with annotation value 'master'!".formatted(className)));
                        SUPPRESSED_NAMES.add(className);
                    }
                    PARENTS.put(source, MASTERS.get(className));
                }
                MASTERS.putIfAbsent(className, source);
            }
            MASTER_CLASSES = (String[])MASTERS.keySet().toArray(String[]::new);
            Arrays.sort(MASTER_CLASSES);
            for (Field field : (List)allAnnotations.getSecond()) {
                categoryLoader = (CategoryLoader)allAnnotations.getFirst();
                annotation = field.getAnnotation(CategoryLoader.Register.class);
                className = categoryLoader.getClass().getCanonicalName();
                object = field.get(categoryLoader);
                if (!(object instanceof class_3419)) continue;
                class_3419 category = (class_3419)object;
                if (!annotation.master()) {
                    if (MASTERS.containsKey(className)) {
                        PARENTS.put(category, MASTERS.get(className));
                    } else if (!SUPPRESSED_NAMES.contains(className)) {
                        ExtraSoundsNext.LOGGER.warn("[{}] Missing annotation value 'master' in class '{}'. This is deprecated.", (Object)ExtraSoundsNext.class.getSimpleName(), (Object)className);
                        ExtraSoundsNext.LOGGER.warn("[{}] To avoid this message, please specify \"master = true\" in one of the @Register annotation in your class.", (Object)ExtraSoundsNext.class.getSimpleName());
                        SUPPRESSED_NAMES.add(className);
                    }
                }
                if (annotation.defaultLevel() != 1.0f) {
                    DEFAULT_LEVELS.put(category, Float.valueOf(annotation.defaultLevel()));
                }
                if (annotation.toggle()) {
                    TOGGLEABLE_CATS.put(category, (Pair<Boolean, Boolean>)Pair.of((Object)true, (Object)annotation.defaultOn()));
                }
                if (annotation.tooltip().isEmpty()) continue;
                TOOLTIPS.put(category, (class_2561)class_2561.method_43471((String)annotation.tooltip()));
            }
        }
        catch (Exception ex) {
            ExtraSoundsNext.LOGGER.error("[%s] Unexpected error has caught".formatted(ExtraSoundsNext.class.getSimpleName()), (Throwable)ex);
        }
        SUPPRESSED_NAMES.clear();
        IS_INITIALIZED = true;
    }

    static {
        IS_INITIALIZED = false;
    }
}

