/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.holder;

import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_7225;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.api.ICreativeConfig;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.holder.ConfigHolder;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;

public class ConfigHolderObject
extends ConfigHolder<ConfigKey> {
    public final Object object;

    public static ConfigHolderObject createUnrelated(Side side, Object value) {
        return ConfigHolderObject.createUnrelated(side, value, value);
    }

    public static ConfigHolderObject createUnrelated(Side side, Object value, Object defaultReference) {
        return new ConfigHolderObject(ConfigTypeConveration.FAKE_PARENT, side.isClient() ? ConfigSynchronization.CLIENT : ConfigSynchronization.SERVER, "", value, defaultReference);
    }

    private static List<Field> collectFields(Class clazz, List<Field> fields) {
        if (clazz.getSuperclass() != Object.class) {
            ConfigHolderObject.collectFields(clazz.getSuperclass(), fields);
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!Modifier.isPublic(declaredFields[i].getModifiers())) continue;
            fields.add(declaredFields[i]);
        }
        return fields;
    }

    public ConfigHolderObject(ICreativeConfigHolder parent, ConfigSynchronization synchronization, String key, Object object) {
        this(parent, synchronization, key, object, object);
    }

    public ConfigHolderObject(ICreativeConfigHolder parent, ConfigSynchronization synchronization, String key, Object object, Object defaultReference) {
        super(parent, key, synchronization);
        this.object = object;
        List<Field> fields = ConfigHolderObject.collectFields(object.getClass(), new ArrayList<Field>());
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (!field.isAnnotationPresent(CreativeConfig.class)) continue;
            try {
                CreativeConfig config = field.getAnnotation(CreativeConfig.class);
                String name = config.name().isEmpty() ? field.getName() : config.name();
                ConfigSynchronization fieldSync = synchronization != ConfigSynchronization.UNIVERSAL ? synchronization : config.type();
                this.fields.add(name, ConfigKey.of(this, field, name, field.get(defaultReference), fieldSync, config.requiresRestart(), object));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void restoreDefault(Side side, boolean ignoreRestart) {
        super.restoreDefault(side, ignoreRestart);
        this.configured(side);
    }

    @Override
    public void load(class_7225.class_7874 provider, boolean loadDefault, boolean ignoreRestart, JsonObject json, Side side) {
        super.load(provider, loadDefault, ignoreRestart, json, side);
        this.configured(side);
    }

    @Override
    public void configured(Side side) {
        Object object = this.object;
        if (object instanceof ICreativeConfig) {
            ICreativeConfig c = (ICreativeConfig)object;
            c.configured(side);
        }
    }
}

