/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.sides;

import java.util.Locale;
import java.util.Set;

public enum DistributionType {
    CLIENT(Set.of("client")),
    SERVER(Set.of("server", "dedicated_server"));

    private static final DistributionType[] VALUES;
    private static final DistributionType[] CACHE;
    private final Set<String> names;

    private DistributionType(Set<String> names) {
        this.names = names;
    }

    public static DistributionType from(Enum<?> other) {
        int ordinal = other.ordinal();
        DistributionType cached = CACHE[ordinal];
        if (cached != null) {
            return cached;
        }
        String name = other.name();
        DistributionType target = null;
        for (DistributionType type : VALUES) {
            if (!type.matches(name)) continue;
            DistributionType.CACHE[ordinal] = target = type;
            break;
        }
        if (target == null) {
            throw new IllegalArgumentException("Cannot create DistributionType from provided enum " + other + " of class " + other.getClass());
        }
        return target;
    }

    public boolean isServer() {
        return this == SERVER;
    }

    public boolean isClient() {
        return this == CLIENT;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public boolean matches(String name) {
        return this.getNames().contains(name.toLowerCase(Locale.ENGLISH));
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    static {
        VALUES = DistributionType.values();
        CACHE = new DistributionType[VALUES.length];
    }
}

