/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_2960;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3956;
import net.minecraft.class_7709;

@IRecipeHandler.For.Container(value={@IRecipeHandler.For(value=class_3859.class), @IRecipeHandler.For(value=class_3920.class), @IRecipeHandler.For(value=class_3861.class), @IRecipeHandler.For(value=class_3862.class)})
public final class CookingRecipeHandler
implements IRecipeHandler<class_1874> {
    private static final Map<class_3956<?>, Pair<String, CookingRecipeFactory<?>>> LOOKUP = ImmutableMap.builder().put((Object)class_3956.field_17547, (Object)Pair.of((Object)"blastFurnace", class_3859::new)).put((Object)class_3956.field_17549, (Object)Pair.of((Object)"campfire", class_3920::new)).put((Object)class_3956.field_17546, (Object)Pair.of((Object)"furnace", class_3861::new)).put((Object)class_3956.field_17548, (Object)Pair.of((Object)"smoker", class_3862::new)).build();

    @Override
    public String dumpToCommandString(IRecipeManager<? super class_1874> manager, class_1874 recipe) {
        Object[] objectArray = new Object[6];
        objectArray[0] = LOOKUP.get(recipe.method_17716()).getFirst();
        objectArray[1] = StringUtil.quoteAndEscape(recipe.method_8114());
        objectArray[2] = ItemStackUtil.getCommandString(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_1874)recipe).method_8110(arg_0)));
        objectArray[3] = IIngredient.fromIngredient((class_1856)recipe.method_8117().get(0)).getCommandString();
        objectArray[4] = Float.valueOf(recipe.method_8171());
        objectArray[5] = recipe.method_8167();
        return String.format("%s.addRecipe(%s, %s, %s, %s, %s);", objectArray);
    }

    @Override
    public <U extends class_1860<?>> boolean doesConflict(IRecipeManager<? super class_1874> manager, class_1874 firstRecipe, U secondRecipe) {
        return IngredientUtil.canConflict((class_1856)firstRecipe.method_8117().get(0), (class_1856)secondRecipe.method_8117().get(0));
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super class_1874> manager, class_1874 recipe) {
        IIngredient ingredient = IIngredient.fromIngredient((class_1856)recipe.method_8117().get(0));
        IDecomposedRecipe decomposition = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Metadata.GROUP, recipe.method_8112()).with(BuiltinRecipeComponents.Metadata.COOKING_BOOK_CATEGORY, recipe.method_45438()).with(BuiltinRecipeComponents.Input.INGREDIENTS, ingredient).with(BuiltinRecipeComponents.Processing.TIME, recipe.method_8167()).with(BuiltinRecipeComponents.Output.EXPERIENCE, Float.valueOf(recipe.method_8171())).with(BuiltinRecipeComponents.Output.ITEMS, IItemStack.of(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((class_1874)recipe).method_8110(arg_0)))).build();
        return Optional.of(decomposition);
    }

    @Override
    public Optional<class_1874> recompose(IRecipeManager<? super class_1874> manager, class_2960 name, IDecomposedRecipe recipe) {
        String group = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP);
        class_7709 category = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.COOKING_BOOK_CATEGORY);
        IIngredient input = recipe.getOrThrowSingle(BuiltinRecipeComponents.Input.INGREDIENTS);
        int cookTime = recipe.getOrThrowSingle(BuiltinRecipeComponents.Processing.TIME);
        float experience = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.EXPERIENCE).floatValue();
        IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Invalid input: empty ingredient");
        }
        if (cookTime <= 0) {
            throw new IllegalArgumentException("Invalid cooking time: less than min allowed 1: " + cookTime);
        }
        if (experience < 0.0f) {
            throw new IllegalArgumentException("Invalid experience: less than min allowed 0:" + experience);
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid output: empty stack");
        }
        CookingRecipeFactory factory = (CookingRecipeFactory)LOOKUP.get(manager.getRecipeType()).getSecond();
        return Optional.of(factory.create(name, group, category, input.asVanillaIngredient(), output.getInternal(), experience, cookTime));
    }

    @FunctionalInterface
    private static interface CookingRecipeFactory<T extends class_1874> {
        public T create(class_2960 var1, String var2, class_7709 var3, class_1856 var4, class_1799 var5, float var6, int var7);
    }
}

