/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.logging;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="PlayerAppender", category="Core", elementType="appender")
public final class PlayerAppender
extends AbstractAppender {
    private static final Map<Level, ChatStyle> STYLES = Map.of(Level.FATAL, new ChatStyle(class_124.field_1079, class_124.field_1061), Level.ERROR, new ChatStyle(class_124.field_1079, class_124.field_1061), Level.WARN, new ChatStyle(class_124.field_1065, class_124.field_1054), Level.INFO, new ChatStyle(class_124.field_1077, class_124.field_1060), Level.DEBUG, new ChatStyle(class_124.field_1064, class_124.field_1076), Level.TRACE, new ChatStyle(class_124.field_1063, class_124.field_1080), Level.ALL, new ChatStyle(class_124.field_1077, class_124.field_1060), Level.OFF, new ChatStyle(class_124.field_1074, class_124.field_1060));
    private final List<WeakReference<class_1657>> players = new ArrayList<WeakReference<class_1657>>();
    private final List<LogMessage> previousMessages = new ArrayList<LogMessage>();

    private PlayerAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    @PluginFactory
    public static PlayerAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @Nullable @PluginElement(value="Layout") Layout<? extends Serializable> layout) {
        return new PlayerAppender(name, filter, layout, true, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
        String message = this.getLayout().toSerializable(event).toString().replaceAll("(\r?\n)|\r", " ");
        LogMessage logMessage = new LogMessage(event.getLevel(), message);
        Iterator<WeakReference<class_1657>> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            class_1657 player = (class_1657)iterator.next().get();
            if (player == null) {
                iterator.remove();
                continue;
            }
            this.sendMessage(player, logMessage);
        }
        this.previousMessages.add(logMessage);
    }

    void addPlayerLogger(class_1657 player) {
        this.players.add(new WeakReference<class_1657>(player));
        this.previousMessages.forEach(event -> this.sendMessage(player, (LogMessage)event));
    }

    void removePlayerLogger(class_1657 player) {
        this.players.removeIf(p -> p.get() == player);
    }

    void clearPreviousMessages() {
        this.previousMessages.clear();
    }

    private void sendMessage(class_1657 player, LogMessage message) {
        ChatStyle style = STYLES.get(message.level());
        class_5250 header = class_2561.method_43470((String)"[%s]: ".formatted(message.level().name())).method_10862(style.levelStyle());
        class_5250 line = class_2561.method_43470((String)message.message()).method_10862(style.messageStyle());
        player.method_43496((class_2561)header.method_10852((class_2561)line));
    }

    private record LogMessage(Level level, String message) {
    }

    private record ChatStyle(class_2583 levelStyle, class_2583 messageStyle) {
        ChatStyle(class_124 levelStyle, class_124 messageStyle) {
            this(class_2583.field_24360.method_10977(levelStyle), class_2583.field_24360.method_10977(messageStyle));
        }
    }
}

