/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.villager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.villager.ActionAddTrade;
import com.blamejared.crafttweaker.api.action.villager.ActionAddWanderingTrade;
import com.blamejared.crafttweaker.api.action.villager.ActionRemoveTrade;
import com.blamejared.crafttweaker.api.action.villager.ActionRemoveWanderingTrade;
import com.blamejared.crafttweaker.api.action.villager.ActionTradeBase;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.villager.CTTradeObject;
import com.blamejared.crafttweaker.api.villager.ITradeRemover;
import com.blamejared.crafttweaker.api.villager.trade.type.BasicTradeListing;
import com.blamejared.crafttweaker.api.villager.trade.type.CustomTradeListing;
import com.blamejared.crafttweaker.api.villager.trade.type.IBasicItemListing;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessDyedArmorForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessEmeraldForItems;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessEnchantedItemForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessItemsAndEmeraldsToItems;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessItemsForEmeralds;
import com.blamejared.crafttweaker.mixin.common.access.villager.AccessTippedArrowForItemsAndEmeralds;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5819;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.villagers.VillagerTrades")
@Document(value="vanilla/api/villager/VillagerTrades")
public class CTVillagerTrades {
    @ZenCodeGlobals.Global(value="villagerTrades")
    public static final CTVillagerTrades INSTANCE = new CTVillagerTrades();
    public static final List<ActionTradeBase> ACTIONS_VILLAGER_TRADES = new ArrayList<ActionTradeBase>();
    public static final List<ActionTradeBase> ACTION_WANDERING_TRADES = new ArrayList<ActionTradeBase>();
    public static final Map<Class<class_3853.class_1652>, Function<class_3853.class_1652, CTTradeObject>> TRADE_CONVERTER = new HashMap<Class<class_3853.class_1652>, Function<class_3853.class_1652, CTTradeObject>>();

    @ZenCodeType.Method
    public void addTrade(class_3852 profession, int villagerLevel, BiFunction<class_1297, class_5819, @ZenCodeType.Nullable class_1914> offerGenerator) {
        CustomTradeListing trade = new CustomTradeListing(offerGenerator);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(class_3852 profession, int villagerLevel, int emeralds, class_1799 forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTradeListing trade = new BasicTradeListing(emeralds, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(class_3852 profession, int villagerLevel, class_1799 input1, class_1799 forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTradeListing trade = new BasicTradeListing(input1, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(class_3852 profession, int villagerLevel, class_1799 input1, class_1799 input2, class_1799 forSale, int maxTrades, int xp, @ZenCodeType.OptionalFloat(value=1.0f) float priceMult) {
        BasicTradeListing trade = new BasicTradeListing(input1, input2, forSale, maxTrades, xp, priceMult);
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void addTrade(class_3852 profession, int villagerLevel, class_3853.class_1652 trade) {
        this.addTradeInternal(profession, villagerLevel, trade);
    }

    @ZenCodeType.Method
    public void removeBasicTrade(class_3852 profession, int villagerLevel, IItemStack forSale, @ZenCodeType.Optional(value="<item:minecraft:air>") IItemStack price, @ZenCodeType.Optional(value="<item:minecraft:air>") IItemStack price2) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof IBasicItemListing) {
                IBasicItemListing basicTrade = (IBasicItemListing)trade;
                boolean saleMatches = forSale.matches(IItemStack.ofMutable(basicTrade.getForSale()));
                if (price.isEmpty() && price2.isEmpty()) {
                    return saleMatches;
                }
                boolean priceMatches = price.matches(IItemStack.ofMutable(basicTrade.getPrice()));
                if (!price.isEmpty() && price2.isEmpty()) {
                    return saleMatches && priceMatches;
                }
                boolean price2Matches = price2.matches(IItemStack.ofMutable(basicTrade.getPrice2()));
                return saleMatches && priceMatches && price2Matches;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeEmeraldForItemsTrade(class_3852 profession, int villagerLevel, class_1792 tradeFor) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof class_3853.class_4161) {
                return ((AccessEmeraldForItems)trade).crafttweaker$getItem() == tradeFor;
            }
            if (trade instanceof IBasicItemListing) {
                IBasicItemListing basicTrade = (IBasicItemListing)trade;
                return basicTrade.getForSale().method_7909() == tradeFor;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeItemsForEmeraldsTrade(class_3852 profession, int villagerLevel, IItemStack sellingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof class_3853.class_4165) {
                return sellingItem.matches(IItemStack.ofMutable(((AccessItemsForEmeralds)trade).crafttweaker$getItemStack()));
            }
            if (trade instanceof IBasicItemListing) {
                IBasicItemListing basicTrade = (IBasicItemListing)trade;
                return IItemStack.ofMutable(basicTrade.getPrice()).matches(sellingItem);
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeItemsAndEmeraldsToItemsTrade(class_3852 profession, int villagerLevel, IItemStack sellingItem, IItemStack buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            IBasicItemListing basicTrade;
            if (trade instanceof class_3853.class_4164) {
                if (sellingItem.matches(IItemStack.ofMutable(((AccessItemsAndEmeraldsToItems)trade).crafttweaker$getToItem()))) {
                    return buyingItem.matches(IItemStack.ofMutable(((AccessItemsAndEmeraldsToItems)trade).crafttweaker$getFromItem()));
                }
            } else if (trade instanceof IBasicItemListing && sellingItem.matches(IItemStack.ofMutable((basicTrade = (IBasicItemListing)trade).getPrice()))) {
                return buyingItem.matches(IItemStack.ofMutable(basicTrade.getForSale()));
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeTippedArrowForItemsAndEmeraldsTrade(class_3852 profession, int villagerLevel, IItemStack potionStack, class_1792 sellingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof class_3853.class_4167 && potionStack.matches(IItemStack.ofMutable(((AccessTippedArrowForItemsAndEmeralds)trade).crafttweaker$getToItem()))) {
                return sellingItem == ((AccessTippedArrowForItemsAndEmeralds)trade).crafttweaker$getFromItem();
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeDyedArmorForEmeraldsTrade(class_3852 profession, int villagerLevel, class_1792 buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof class_3853.class_4160) {
                return ((AccessDyedArmorForEmeralds)trade).crafttweaker$getItem() == buyingItem;
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeTreasureMapForEmeraldsTrade(class_3852 profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof class_3853.class_1654);
    }

    @ZenCodeType.Method
    public void removeEnchantBookForEmeraldsTrade(class_3852 profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof class_3853.class_1648);
    }

    @ZenCodeType.Method
    public void removeEnchantedItemForEmeraldsTrade(class_3852 profession, int villagerLevel, IItemStack buyingItem) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            if (trade instanceof class_3853.class_4163) {
                return buyingItem.matches(IItemStack.ofMutable(((AccessEnchantedItemForEmeralds)trade).crafttweaker$getItemStack()));
            }
            return false;
        });
    }

    @ZenCodeType.Method
    public void removeSuspiciousStewForEmeraldTrade(class_3852 profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> trade instanceof class_3853.class_4166);
    }

    @ZenCodeType.Method
    public void removeAllTrades(class_3852 profession, int villagerLevel) {
        this.removeTradeInternal(profession, villagerLevel, trade -> true);
    }

    @ZenCodeType.Method
    public void removeTrade(class_3852 profession, int villagerLevel, IIngredient buying, IIngredient selling, @ZenCodeType.Optional(value="<item:minecraft:air>") IIngredient secondBuying) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<class_3853.class_1652, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            if (!buying.matches(tradeObject.getBuyingStack())) {
                return false;
            }
            if (!selling.matches(tradeObject.getSellingStack())) {
                return false;
            }
            return secondBuying.matches(tradeObject.getBuyingStackSecond());
        });
    }

    @ZenCodeType.Method
    public void removeTradesSelling(class_3852 profession, int villagerLevel, IIngredient selling) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<class_3853.class_1652, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            return selling.matches(tradeObject.getSellingStack());
        });
    }

    @ZenCodeType.Method
    public void removeTradesBuying(class_3852 profession, int villagerLevel, IIngredient buying) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<class_3853.class_1652, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            return buying.matches(tradeObject.getBuyingStack());
        });
    }

    @ZenCodeType.Method
    public void removeTradesBuying(class_3852 profession, int villagerLevel, IIngredient buying, IIngredient secondBuying) {
        this.removeTradeInternal(profession, villagerLevel, trade -> {
            Function<class_3853.class_1652, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            if (!buying.matches(tradeObject.getBuyingStack())) {
                return false;
            }
            return secondBuying.matches(tradeObject.getBuyingStackSecond());
        });
    }

    @ZenCodeType.Method
    public void addWanderingTrade(int rarity, class_3853.class_1652 trade) {
        this.addWanderingTradeInternal(rarity, trade);
    }

    @ZenCodeType.Method
    public void addWanderingTrade(int rarity, int emeralds, class_1799 forSale, int maxTrades, int xp) {
        BasicTradeListing trade = new BasicTradeListing(emeralds, forSale, maxTrades, xp, 1.0f);
        this.addWanderingTradeInternal(rarity, trade);
    }

    @ZenCodeType.Method
    public void addWanderingTrade(int rarity, IItemStack price, IItemStack forSale, int maxTrades, int xp) {
        BasicTradeListing trade = new BasicTradeListing(price.getInternal(), forSale.getInternal(), maxTrades, xp, 1.0f);
        this.addWanderingTradeInternal(rarity, trade);
    }

    @Deprecated(forRemoval=true)
    public void removeWanderingTrade(int rarity, IItemStack tradeFor) {
        this.removeWanderingTrade(rarity, (IIngredient)tradeFor);
    }

    @ZenCodeType.Method
    public void removeWanderingTrade(int rarity, IIngredient tradeFor) {
        this.removeWanderingTradeInternal(rarity, trade -> {
            Function<class_3853.class_1652, CTTradeObject> tradeFunc = TRADE_CONVERTER.get(trade.getClass());
            if (tradeFunc == null) {
                return false;
            }
            CTTradeObject tradeObject = tradeFunc.apply(trade);
            return tradeFor.matches(tradeObject.getSellingStack());
        });
    }

    @ZenCodeType.Method
    public void removeAllWanderingTrades(int rarity) {
        this.removeWanderingTradeInternal(rarity, trade -> true);
    }

    private void addTradeInternal(class_3852 profession, int villagerLevel, class_3853.class_1652 trade) {
        this.apply(new ActionAddTrade(profession, villagerLevel, trade), false);
    }

    private void addWanderingTradeInternal(int villagerLevel, class_3853.class_1652 trade) {
        this.apply(new ActionAddWanderingTrade(villagerLevel, trade), true);
    }

    private void removeTradeInternal(class_3852 profession, int villagerLevel, ITradeRemover remover) {
        this.apply(new ActionRemoveTrade(profession, villagerLevel, remover), false);
    }

    private void removeWanderingTradeInternal(int villagerLevel, ITradeRemover remover) {
        this.apply(new ActionRemoveWanderingTrade(villagerLevel, remover), true);
    }

    private void apply(ActionTradeBase action, boolean wandering) {
        if (wandering) {
            ACTION_WANDERING_TRADES.add(action);
        } else {
            ACTIONS_VILLAGER_TRADES.add(action);
        }
        CraftTweakerAPI.apply(action);
    }

    public static void clear() {
        ACTIONS_VILLAGER_TRADES.clear();
        ACTION_WANDERING_TRADES.clear();
    }
}

