/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.mod;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_7923;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.mod.Mod")
@Document(value="vanilla/api/mod/Mod")
public final class Mod {
    private final String id;
    private final String displayName;
    private final String version;

    public Mod(String id, String displayName, String version) {
        this.id = id;
        this.displayName = displayName;
        this.version = version;
    }

    private <T> Collection<T> getRegistryObjects(class_2378<T> registry) {
        return registry.method_10235().stream().filter(resourceLocation -> resourceLocation.method_12836().equals(this.id())).map(resourceLocation -> registry.method_17966(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Cannot get registry object from name: '" + resourceLocation + "'! This should never happen!"))).toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="items")
    public Collection<class_1792> getItems() {
        return this.getRegistryObjects((class_2378)class_7923.field_41178);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="itemStacks")
    public Collection<IItemStack> getItemStacks() {
        return this.getItems().stream().map(class_1792::method_7854).map(IItemStack::of).toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="potions")
    public Collection<class_1842> getPotions() {
        return this.getRegistryObjects((class_2378)class_7923.field_41179);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="attributes")
    public Collection<class_1320> getAttributes() {
        return this.getRegistryObjects(class_7923.field_41190);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="fluids")
    public Collection<class_3611> getFluids() {
        return this.getRegistryObjects((class_2378)class_7923.field_41173);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="enchantments")
    public Collection<class_1887> getEnchantments() {
        return this.getRegistryObjects(class_7923.field_41176);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="blocks")
    public Collection<class_2248> getBlocks() {
        return this.getRegistryObjects((class_2378)class_7923.field_41175);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="mobEffects")
    public Collection<class_1291> getMobEffects() {
        return this.getRegistryObjects(class_7923.field_41174);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="villagerProfessions")
    public Collection<class_3852> getVillagerProfessions() {
        return this.getRegistryObjects((class_2378)class_7923.field_41195);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="soundEvents")
    public Collection<class_3414> getSoundEvents() {
        return this.getRegistryObjects(class_7923.field_41172);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="id")
    public String id() {
        return this.id;
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="displayName")
    public String displayName() {
        return this.displayName;
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="version")
    public String version() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Mod that = (Mod)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.version);
    }

    public String toString() {
        return "Mod[id=" + this.id + ", displayName=" + this.displayName + ", version=" + this.version + "]";
    }
}

