/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.impl.fluid.SimpleFluidStack;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import org.openzen.zencode.java.ZenCodeType;

public class MCFluidStackMutable
implements IFluidStack {
    private final SimpleFluidStack stack;

    public MCFluidStackMutable(SimpleFluidStack stack) {
        this.stack = stack;
    }

    @Override
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @Override
    public long getAmount() {
        return this.getInternal().amount();
    }

    @Override
    public IFluidStack setAmount(int amount) {
        this.getInternal().amount(amount);
        return this;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public class_3611 getFluid() {
        return this.getInternal().fluid();
    }

    @Override
    public IFluidStack withTag(IData tag) {
        if (tag != null) {
            MapData map = new MapData(tag.asMap());
            this.getInternal().tag(map.getInternal());
        } else {
            this.getInternal().tag(null);
        }
        return this;
    }

    @Override
    public boolean hasTag() {
        return this.getInternal().tag() != null;
    }

    @Override
    public class_2487 getInternalTag() {
        return this.getInternal().tag();
    }

    @Override
    public IData getTag() {
        return TagToDataConverter.convert((class_2520)this.getInternal().tag());
    }

    public SimpleFluidStack getInternal() {
        return this.stack;
    }

    public SimpleFluidStack getImmutableInternal() {
        return this.stack.copy();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFluidStack thatStack = ((MCFluidStackMutable)o).getInternal();
        SimpleFluidStack thisStack = this.getInternal();
        if (thisStack.isEmpty()) {
            return thatStack.isEmpty();
        }
        if (thisStack.amount() != thatStack.amount()) {
            return false;
        }
        if (!Objects.equals(thisStack.fluid(), thatStack.fluid())) {
            return false;
        }
        return Objects.equals(thisStack.tag(), thatStack.tag());
    }

    public int hashCode() {
        return Objects.hash(this.getInternal().amount(), this.getInternal().fluid(), this.getInternal().tag());
    }
}

