/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.entity;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker.natives.entity.ExpandEntityType;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_6862;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.entity.EntityIngredient")
@Document(value="vanilla/api/entity/EntityIngredient")
public abstract class CTEntityIngredient
implements CommandStringDisplayable {
    CTEntityIngredient() {
    }

    @Override
    public abstract String getCommandString();

    public abstract boolean matches(class_1299<?> var1);

    public abstract boolean matches(class_1299<?> var1, int var2);

    public abstract boolean matches(class_6862<class_1299<?>> var1);

    public abstract boolean matches(class_6862<class_1299<?>> var1, int var2);

    public abstract <T> T mapTo(Function<class_1299<?>, T> var1, BiFunction<class_6862<class_1299<?>>, Integer, T> var2, Function<Stream<T>, T> var3);

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public CTEntityIngredient asCompound(CTEntityIngredient other) {
        ArrayList<CTEntityIngredient> ingredients = new ArrayList<CTEntityIngredient>();
        if (other instanceof CompoundEntityIngredient) {
            ingredients.addAll(((CompoundEntityIngredient)other).elements);
        } else {
            ingredients.add(other);
        }
        if (this instanceof CompoundEntityIngredient) {
            ((CompoundEntityIngredient)this).elements.addAll(ingredients);
            return this;
        }
        ingredients.add(this);
        return new CompoundEntityIngredient(ingredients);
    }

    public static final class CompoundEntityIngredient
    extends CTEntityIngredient {
        final List<CTEntityIngredient> elements;

        public CompoundEntityIngredient(List<CTEntityIngredient> elements) {
            this.elements = elements;
        }

        @Override
        public String getCommandString() {
            return this.elements.stream().map(CTEntityIngredient::getCommandString).collect(Collectors.joining(" | "));
        }

        @Override
        public boolean matches(class_1299<?> type) {
            return this.elements.stream().anyMatch(ctEntityIngredient -> ctEntityIngredient.matches(type));
        }

        @Override
        public boolean matches(class_1299<?> type, int amount) {
            return this.elements.stream().anyMatch(ctEntityIngredient -> ctEntityIngredient.matches(type, amount));
        }

        @Override
        public boolean matches(class_6862<class_1299<?>> tag) {
            return this.elements.stream().anyMatch(ctEntityIngredient -> ctEntityIngredient.matches(tag));
        }

        @Override
        public boolean matches(class_6862<class_1299<?>> tag, int amount) {
            return this.elements.stream().anyMatch(ctEntityIngredient -> ctEntityIngredient.matches(tag, amount));
        }

        @Override
        public <T> T mapTo(Function<class_1299<?>, T> typeMapper, BiFunction<class_6862<class_1299<?>>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            Stream<Object> stream = this.elements.stream().map(element -> element.mapTo(typeMapper, tagMapper, compoundMapper));
            return compoundMapper.apply(stream);
        }
    }

    public static final class EntityTagWithAmountIngredient
    extends CTEntityIngredient {
        final Many<KnownTag<class_1299<?>>> tag;

        public EntityTagWithAmountIngredient(Many<KnownTag<class_1299<?>>> tag) {
            this.tag = tag;
        }

        @Override
        public boolean matches(class_1299<?> type) {
            return this.tag.getData().contains(type);
        }

        @Override
        public boolean matches(class_1299<?> type, int amount) {
            return this.tag.getData().contains(type) && this.tag.getAmount() <= amount;
        }

        @Override
        public boolean matches(class_6862<class_1299<?>> tag) {
            return this.tag.getData().getTagKey().equals(tag);
        }

        @Override
        public boolean matches(class_6862<class_1299<?>> tag, int amount) {
            return this.tag.getData().getTagKey().equals(tag) && this.tag.getAmount() <= amount;
        }

        @Override
        public String getCommandString() {
            return this.tag.getCommandString();
        }

        @Override
        public <T> T mapTo(Function<class_1299<?>, T> typeMapper, BiFunction<class_6862<class_1299<?>>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            return tagMapper.apply((class_6862<class_1299<?>>)this.tag.getData().getTagKey(), this.tag.getAmount());
        }
    }

    public static final class EntityTypeIngredient
    extends CTEntityIngredient {
        final class_1299<?> entityType;

        public EntityTypeIngredient(class_1299<?> entityType) {
            this.entityType = entityType;
        }

        @Override
        public String getCommandString() {
            return ExpandEntityType.getCommandString((class_1299<class_1297>)((class_1299)GenericUtil.uncheck(this.entityType)));
        }

        @Override
        public boolean matches(class_1299<?> type) {
            return this.entityType == type;
        }

        @Override
        public boolean matches(class_1299<?> type, int amount) {
            return this.matches(type);
        }

        @Override
        public boolean matches(class_6862<class_1299<?>> tag) {
            return this.entityType.method_20210(tag);
        }

        @Override
        public boolean matches(class_6862<class_1299<?>> tag, int amount) {
            return this.matches(tag);
        }

        @Override
        public <T> T mapTo(Function<class_1299<?>, T> typeMapper, BiFunction<class_6862<class_1299<?>>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            return typeMapper.apply(this.entityType);
        }
    }
}

