/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe.generic;

import com.blamejared.crafttweaker.api.action.recipe.generic.ActionWholeRegistryBase;
import com.blamejared.crafttweaker.api.recipe.RecipeList;
import com.blamejared.crafttweaker.api.recipe.manager.RecipeManagerWrapper;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1860;
import net.minecraft.class_3956;

public abstract class ActionRemoveGenericRecipeBase
extends ActionWholeRegistryBase {
    @Override
    public void apply() {
        TreeMap<String, Integer> numberOfRemovedRecipesByType = new TreeMap<String, Integer>();
        int numberOfRemovedRecipes = 0;
        Map<class_3956<class_1860<?>>, RecipeList<?>> recipeLists = this.getRecipeLists();
        for (class_3956<class_1860<?>> recipeType : recipeLists.keySet()) {
            int removedRecipes = this.applyToRegistry(recipeLists.get(recipeType));
            if (removedRecipes <= 0) continue;
            String commandString = new RecipeManagerWrapper(recipeType).getCommandString();
            numberOfRemovedRecipesByType.put(commandString, removedRecipes);
            numberOfRemovedRecipes += removedRecipes;
        }
        int numberOfRecipeTypes = numberOfRemovedRecipesByType.size();
        String recipeTypeList = this.makeRecipeList(numberOfRemovedRecipesByType);
        this.logger().info("Removed {} recipes registered in these {} recipe managers: {}", (Object)numberOfRemovedRecipes, (Object)numberOfRecipeTypes, (Object)recipeTypeList);
    }

    private int applyToRegistry(RecipeList<?> list) {
        int initialSize = list.getSize();
        list.removeByRecipeTest(this::shouldRemove);
        return initialSize - list.getSize();
    }

    protected abstract boolean shouldRemove(class_1860<?> var1);
}

